/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.properties;

import com.mcmoddev.basemetals.properties.BMEPropertyBase;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.IMMDObject;
import com.mcmoddev.lib.material.MMDMaterial;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;

public class StarSteelProperty
extends BMEPropertyBase {
    public void apply(ItemStack stack) {
        if (this.hasEffect(stack)) {
            // empty if block
        }
    }

    public void apply(ItemStack stack, EntityPlayer player) {
        if (this.hasEffect(stack, player)) {
            int num = StarSteelProperty.countArmorPieces(Materials.getMaterialByName((String)"starsteel"), player);
            if (num == 0) {
                return;
            }
            PotionEffect jumpBoost = new PotionEffect(MobEffects.field_76430_j, 45, num - 1, false, false);
            player.func_70690_d(jumpBoost);
            if (num > 1) {
                PotionEffect speedBoost = new PotionEffect(MobEffects.field_76424_c, 45, num - 2, false, false);
                player.func_70690_d(speedBoost);
            }
        }
    }

    public void apply(ItemStack stack, EntityLivingBase ent) {
        if (this.hasEffect(stack, ent) && ent instanceof EntityPlayer) {
            this.apply(stack, (EntityPlayer)ent);
        }
    }

    public boolean hasEffect(ItemStack stack) {
        return false;
    }

    public boolean hasEffect(ItemStack stack, EntityPlayer player) {
        MMDMaterial mat = Materials.getMaterialByName((String)"starsteel");
        boolean rv = StarSteelProperty.stackIsArmorMaterial(stack, mat) && stack.func_77973_b() instanceof IMMDObject && ((IMMDObject)stack.func_77973_b()).getMMDMaterial() == mat && StarSteelProperty.countArmorPieces(Materials.getMaterialByName((String)"starsteel"), player) > 0;
        return rv;
    }

    public boolean hasEffect(ItemStack stack, EntityLivingBase ent) {
        return ent instanceof EntityPlayer ? this.hasEffect(stack, (EntityPlayer)ent) : false;
    }
}

