/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.items;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class MMDToolEffects {
    private static final String TOOLTIP = "tooltip.";
    private static final String ARMOR = ".armor";
    private static final String TOOL = ".tool";
    private static final int EFFECT_DURATION = 45;
    private static final Map<EntityPlayer, AtomicInteger> starsteelUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();
    private static final Map<EntityPlayer, AtomicInteger> adamantineUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();
    private static final Map<EntityPlayer, AtomicInteger> leadUpdateCache = new HashMap<EntityPlayer, AtomicInteger>();

    private MMDToolEffects() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void extraEffectsOnAttack(MMDMaterial material, ItemStack itemStack, EntityLivingBase target, EntityLivingBase attacker) {
        String materialName = material.getName();
        if (materialName.equals("coldiron")) {
            if (target.func_70045_F()) {
                DamageSource extraDamage = DamageSource.field_76377_j;
                target.func_70097_a(extraDamage, 3.0f);
            }
        } else if (materialName.equals("adamantine")) {
            if (target.func_110138_aP() > 20.0f) {
                DamageSource extraDamage = DamageSource.field_76377_j;
                target.func_70097_a(extraDamage, 4.0f);
            }
        } else if (materialName.equals("mithril")) {
            if (target.func_70668_bt() == EnumCreatureAttribute.UNDEAD) {
                PotionEffect wither = new PotionEffect(MobEffects.field_82731_v, 60, 3);
                PotionEffect blind = new PotionEffect(MobEffects.field_76440_q, 60, 1);
                target.func_70690_d(wither);
                target.func_70690_d(blind);
            }
        } else if (materialName.equals("aquarium") && target.func_70648_aU()) {
            DamageSource extraDamage = DamageSource.field_76377_j;
            target.func_70097_a(extraDamage, 4.0f);
        }
    }

    public static void extraEffectsOnCrafting(MMDMaterial material, ItemStack item, World world, EntityPlayer crafter) {
    }

    public static void extraEffectsOnArmorUpdate(World world, @Nullable EntityPlayer player, MMDMaterial material, ItemStack armor, int i) {
        if (armor.func_190926_b()) {
            return;
        }
        if (armor.func_77973_b() == null) {
            return;
        }
        if (player == null) {
            return;
        }
        String materialName = material.getName();
        if (i % 2 == 0) {
            switch (materialName) {
                case "adamantine": {
                    MMDToolEffects.countArmorPieces(adamantineUpdateCache, player);
                    break;
                }
                case "lead": {
                    MMDToolEffects.countArmorPieces(leadUpdateCache, player);
                    break;
                }
                case "starsteel": {
                    MMDToolEffects.countStarsteelPieces(player);
                    break;
                }
            }
        } else {
            switch (materialName) {
                case "adamantine": {
                    MMDToolEffects.applyEffectsForAdamantine(player);
                    break;
                }
                case "aquarium": {
                    MMDToolEffects.applyEffectsForAquarium(player, world);
                    break;
                }
                case "coldiron": {
                    MMDToolEffects.applyEffectsForColdiron(player);
                    break;
                }
                case "lead": {
                    MMDToolEffects.applyEffectsForLead(player);
                    break;
                }
                case "mithril": {
                    MMDToolEffects.applyEffectsForMithril(player);
                    break;
                }
                case "starsteel": {
                    MMDToolEffects.applyEffectsForStarsteel(player);
                    break;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addToolSpecialPropertiesToolTip(String materialName, List<String> tooltipList) {
        switch (materialName) {
            case "adamantine": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.adamantine.tool", (Object[])new Object[]{4}));
                break;
            }
            case "aquarium": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.aquarium.tool", (Object[])new Object[]{4}));
                break;
            }
            case "coldiron": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.coldiron.tool", (Object[])new Object[]{3}));
                break;
            }
            case "mithril": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.mithril.tool", (Object[])new Object[0]));
                break;
            }
            case "starsteel": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.starsteel.tool", (Object[])new Object[]{10}));
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void addArmorSpecialPropertiesToolTip(String materialName, List<String> tooltipList) {
        switch (materialName) {
            case "adamantine": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.adamantine.armor", (Object[])new Object[]{4}));
                break;
            }
            case "aquarium": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.aquarium.armor", (Object[])new Object[]{4}));
                break;
            }
            case "coldiron": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.coldiron.armor", (Object[])new Object[]{3}));
                break;
            }
            case "mithril": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.mithril.armor", (Object[])new Object[0]));
                break;
            }
            case "starsteel": {
                tooltipList.add(I18n.func_135052_a((String)"tooltip.starsteel.armor", (Object[])new Object[]{10}));
                break;
            }
        }
    }

    private static void countArmorPieces(Map<EntityPlayer, AtomicInteger> updateCache, EntityPlayer player) {
        if (!updateCache.containsKey(player)) {
            updateCache.put(player, new AtomicInteger(0));
        }
        updateCache.get(player).incrementAndGet();
    }

    private static boolean hasFullSuit(EntityPlayer player, String materialName) {
        MMDMaterial material = Materials.getMaterialByName((String)materialName);
        return player.func_184582_a(EntityEquipmentSlot.HEAD).func_77973_b() == material.getItem(Names.HELMET) && player.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == material.getItem(Names.CHESTPLATE) && player.func_184582_a(EntityEquipmentSlot.LEGS).func_77973_b() == material.getItem(Names.LEGGINGS) && player.func_184582_a(EntityEquipmentSlot.FEET).func_77973_b() == material.getItem(Names.BOOTS);
    }

    private static void countStarsteelPieces(EntityPlayer player) {
        MMDToolEffects.countArmorPieces(starsteelUpdateCache, player);
    }

    private static void applyEffectsForStarsteel(EntityPlayer player) {
        if (!starsteelUpdateCache.containsKey(player)) {
            return;
        }
        int num = starsteelUpdateCache.get(player).getAndSet(0);
        if (num == 0) {
            return;
        }
        PotionEffect jumpBoost = new PotionEffect(MobEffects.field_76430_j, 45, num - 1, false, false);
        player.func_70690_d(jumpBoost);
        if (num > 1) {
            PotionEffect speedBoost = new PotionEffect(MobEffects.field_76424_c, 45, num - 2, false, false);
            player.func_70690_d(speedBoost);
        }
    }

    private static void applyEffectsForLead(EntityPlayer player) {
        if (!leadUpdateCache.containsKey(player)) {
            return;
        }
        int level = leadUpdateCache.get(player).getAndSet(0) / 2;
        if (level == 0) {
            return;
        }
        if (level > 0) {
            PotionEffect speedLoss = new PotionEffect(MobEffects.field_76421_d, 45, level - 1, false, false);
            player.func_70690_d(speedLoss);
        }
    }

    private static void applyEffectsForAdamantine(EntityPlayer player) {
        if (!adamantineUpdateCache.containsKey(player)) {
            return;
        }
        int num = adamantineUpdateCache.get(player).getAndSet(0);
        int level = num / 2;
        if (level == 0) {
            return;
        }
        if (level > 0) {
            PotionEffect protection = new PotionEffect(MobEffects.field_76429_m, 45, level - 1, false, false);
            player.func_70690_d(protection);
        }
    }

    private static void applyEffectsForColdiron(EntityPlayer player) {
        if (MMDToolEffects.hasFullSuit(player, "coldiron")) {
            PotionEffect fireProtection = new PotionEffect(MobEffects.field_76426_n, 45, 0, false, false);
            player.func_70690_d(fireProtection);
        }
    }

    private static void applyEffectsForMithril(EntityPlayer player) {
        if (MMDToolEffects.hasFullSuit(player, "mithril")) {
            LinkedList<Potion> removeList = new LinkedList<Potion>();
            for (PotionEffect pe : player.func_70651_bq()) {
                Potion p = pe.func_188419_a();
                if (!p.func_76398_f()) continue;
                removeList.add(p);
            }
            for (Potion p : removeList) {
                player.func_184589_d(p);
            }
        }
    }

    private static void applyEffectsForAquarium(EntityPlayer player, World w) {
        if (MMDToolEffects.hasFullSuit(player, "aquarium") && player.field_70163_u > 0.0 && player.field_70163_u < 255.0) {
            Block b1 = w.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177230_c();
            Block b2 = w.func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u + 1.0, player.field_70161_v)).func_177230_c();
            if (b1 == Blocks.field_150355_j && b2 == Blocks.field_150355_j) {
                PotionEffect waterBreathing = new PotionEffect(MobEffects.field_76427_o, 45, 0, false, false);
                player.func_70690_d(waterBreathing);
                PotionEffect protection = new PotionEffect(MobEffects.field_76429_m, 45, 0, false, false);
                player.func_70690_d(protection);
                player.func_184589_d(MobEffects.field_76419_f);
            }
        }
    }
}

