/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.IntegrationPostInitEvent;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.TinkersConstruct;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkerTraitLocation;
import com.mcmoddev.lib.integration.plugins.tinkers.TinkersMaterial;
import com.mcmoddev.lib.integration.plugins.tinkers.events.MaterialRegistrationEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersAlloyRecipeEvent;
import com.mcmoddev.lib.integration.plugins.tinkers.events.TinkersExtraMeltingsEvent;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.CheeseMath;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.smeltery.TinkerSmeltery;

@MMDPlugin(addonId="basemetals", pluginId="tconstruct", versions="tconstruct@[1.12.2-2.7.4.0,)")
public class BMeTinkersConstruct
implements IIntegration {
    public static final String PLUGIN_MODID = "tconstruct";

    public void init() {
        TinkersConstruct.INSTANCE.init();
        if (!TConstruct.pulseManager.isPulseLoaded("TinkerSmeltery")) {
            return;
        }
        if (!Config.Options.isModEnabled((String)PLUGIN_MODID)) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void registerMiscShit(RegistryEvent.Register<IRecipe> ev) {
        List<Names> items = Arrays.asList(Names.CHESTPLATE, Names.LEGGINGS, Names.HELMET, Names.BOOTS);
        List materials = (List)Materials.getMaterialsByMod((String)"basemetals");
        materials.stream().filter(b -> b.getFluid() != null).forEach(base -> items.stream().filter(n -> base.hasItem(n)).filter(nv -> base.getItem(nv).getRegistryName().func_110624_b().equalsIgnoreCase("basemetals")).map(name -> Pair.of((Object)name.toString(), (Object)CheeseMath.getIngotCount((MMDMaterial)base, (ItemStack)base.getItemStack(name)))).filter(evx -> (Integer)evx.getValue() > 1).forEach(evga -> TinkersConstruct.INSTANCE.addExtraMelting(base.getName(), Integer.valueOf((Integer)evga.getRight() * 144), base.getItemStack((String)evga.getLeft()))));
    }

    @SubscribeEvent
    public void postInit(IntegrationPostInitEvent event) {
        BMeTinkersConstruct.registerPrismarineFullCasting();
    }

    public static void registerPrismarineFullCasting() {
        int gemAmount = 144;
        int blockAmount = 4 * gemAmount;
        Fluid fluid = FluidRegistry.getFluid((String)"prismarine");
        TinkersConstruct.registerTableCasting((ItemStack)new ItemStack(Items.field_179562_cC, 1), (ItemStack)TinkerSmeltery.castGem, (Fluid)fluid, (int)gemAmount);
        TinkersConstruct.registerBasinCasting((ItemStack)new ItemStack(Blocks.field_180397_cI, 1), (Fluid)fluid, (int)blockAmount);
    }

    @SubscribeEvent
    public void materialRegistration(MaterialRegistrationEvent ev) {
        this.registerMaterial("adamantine", ev, "coldblooded", "insatiable");
        this.registerMaterial("antimony", ev, "brittle");
        this.registerMaterial("aquarium", ev, "aquadynamic", TinkerTraitLocation.HEAD, "jagged", TinkerTraitLocation.HEAD, "aquadynamic");
        this.registerMaterial("bismuth", ev, new Object[0]);
        this.registerMaterial("brass", ev, "dense");
        this.registerMaterial("coldiron", ev, "freezing");
        this.registerMaterial("cupronickel", ev, new Object[0]);
        this.registerMaterial("invar", ev, new Object[0]);
        this.registerMaterial("lead", ev, "soft");
        this.registerMaterial("mithril", ev, "holy");
        this.registerMaterial("nickel", ev, "magnetic", TinkerTraitLocation.HEAD, "shocking", TinkerTraitLocation.HEAD, "magnetic2", "shocking");
        this.registerMaterial("pewter", ev, "soft");
        this.registerMaterial("platinum", ev, new Object[0]);
        this.registerMaterial("starsteel", ev, "enderference", TinkerTraitLocation.HEAD, "sparkly");
        this.registerMaterial("tin", ev, new Object[0]);
        this.registerMaterial("zinc", ev, "reactive");
    }

    protected void registerMaterial(String name, MaterialRegistrationEvent ev, Object ... traits) {
        this.registerMaterial(Config.Options.isMaterialEnabled((String)name), name, ev, traits);
    }

    protected void registerMaterial(boolean active, String name, MaterialRegistrationEvent ev, Object ... traits) {
        this.registerMaterial(active, name, true, false, ev, traits);
    }

    protected void registerMaterial(boolean active, String name, boolean castable, boolean craftable, MaterialRegistrationEvent ev, Object ... traits) {
        if (active) {
            TinkersMaterial mat = new TinkersMaterial(Materials.getMaterialByName((String)name)).setCastable(castable).setCraftable(craftable).setToolForge(true);
            for (int i = 0; i < traits.length; ++i) {
                String trait;
                Object item = traits[i];
                if (item instanceof TinkerTraitLocation) {
                    TinkerTraitLocation loc = (TinkerTraitLocation)item;
                    trait = ((String)traits[++i]).toLowerCase(Locale.US);
                    mat.addTrait(trait, loc);
                    continue;
                }
                trait = ((String)item).toLowerCase(Locale.US);
                mat.addTrait(trait);
            }
            ev.getRegistry().register((IForgeRegistryEntry)mat.create());
        }
    }

    @SubscribeEvent
    public void registerMeltings(TinkersExtraMeltingsEvent ev) {
        if (this.isMaterialFluidEnabled("coal")) {
            TinkersConstruct.INSTANCE.addExtraMelting(FluidRegistry.getFluidStack((String)"coal", (int)144), new ItemStack(Items.field_151044_h));
        }
        if (this.isMaterialFluidEnabled("mercury")) {
            MMDMaterial mercury = Materials.getMaterialByName((String)"mercury");
            TinkersConstruct.INSTANCE.addExtraMelting(FluidRegistry.getFluidStack((String)mercury.getName(), (int)144), mercury.getItemStack(Names.INGOT));
        }
        if (this.isMaterialFluidEnabled("prismarine")) {
            MMDMaterial prismarine = Materials.getMaterialByName((String)"prismarine");
            TinkersConstruct.INSTANCE.addExtraMelting(FluidRegistry.getFluidStack((String)prismarine.getName(), (int)144), new ItemStack(Items.field_179562_cC));
        }
    }

    private boolean isMaterialFluidEnabled(String identifier) {
        return Config.Options.isMaterialEnabled((String)identifier) && FluidRegistry.getFluid((String)identifier) != null;
    }

    private boolean isValidAlloyMaterial(String identifier) {
        return Materials.hasMaterial((String)identifier) && FluidRegistry.getFluid((String)identifier) != null;
    }

    @SubscribeEvent
    public void registerMyAlloys(TinkersAlloyRecipeEvent ev) {
        FluidStack iron;
        FluidStack nickel;
        FluidStack copper;
        if (this.isValidAlloyMaterial("aquarium") && this.isValidAlloyMaterial("copper") && this.isValidAlloyMaterial("zinc")) {
            copper = FluidRegistry.getFluidStack((String)"copper", (int)2);
            FluidStack zinc = FluidRegistry.getFluidStack((String)"zinc", (int)1);
            FluidStack prismarine = FluidRegistry.getFluidStack((String)"prismarine", (int)3);
            ev.addAlloyRecipe("aquarium", 3, new FluidStack[]{copper, zinc, prismarine});
        }
        if (this.isValidAlloyMaterial("cupronickel") && this.isValidAlloyMaterial("copper") && this.isValidAlloyMaterial("nickel")) {
            copper = FluidRegistry.getFluidStack((String)"copper", (int)3);
            nickel = FluidRegistry.getFluidStack((String)"nickel", (int)1);
            ev.addAlloyRecipe("cupronickel", 4, new FluidStack[]{copper, nickel});
        }
        if (this.isValidAlloyMaterial("invar") && this.isValidAlloyMaterial("nickel")) {
            iron = FluidRegistry.getFluidStack((String)"iron", (int)2);
            nickel = FluidRegistry.getFluidStack((String)"nickel", (int)1);
            ev.addAlloyRecipe("invar", 3, new FluidStack[]{iron, nickel});
        }
        if (this.isValidAlloyMaterial("mithril") && this.isValidAlloyMaterial("coldiron") && this.isValidAlloyMaterial("silver") && this.isValidAlloyMaterial("mercury")) {
            FluidStack coldiron = FluidRegistry.getFluidStack((String)"coldiron", (int)1);
            FluidStack silver = FluidRegistry.getFluidStack((String)"silver", (int)2);
            FluidStack mercury = FluidRegistry.getFluidStack((String)"mercury", (int)1);
            ev.addAlloyRecipe("mithril", 3, new FluidStack[]{coldiron, silver, mercury});
        }
        if (this.isValidAlloyMaterial("pewter") && Materials.hasMaterial((String)"lead") && this.isValidAlloyMaterial("copper") && this.isValidAlloyMaterial("tin")) {
            copper = FluidRegistry.getFluidStack((String)"copper", (int)2);
            FluidStack tin = FluidRegistry.getFluidStack((String)"tin", (int)137);
            FluidStack lead = FluidRegistry.getFluidStack((String)"lead", (int)5);
            ev.addAlloyRecipe("pewter", 144, new FluidStack[]{copper, tin, lead});
        }
        if (this.isValidAlloyMaterial("steel")) {
            iron = FluidRegistry.getFluidStack((String)"iron", (int)8);
            FluidStack coal = FluidRegistry.getFluidStack((String)"coal", (int)1);
            ev.addAlloyRecipe("steel", 8, new FluidStack[]{iron, coal});
        }
    }
}

