/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import cofh.api.util.ThermalExpansionHelper;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.ThermalExpansion;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MMDPlugin(addonId="basemetals", pluginId="thermalexpansion", versions="thermalexpansion@(,5.3.12.17];")
public final class BMeThermalExpansion
extends ThermalExpansion
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"thermalexpansion")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void regShit(RegistryEvent.Register<IRecipe> event) {
        List<String> materials = Arrays.asList("adamantine", "antimony", "aquarium", "bismuth", "brass", "coldiron", "cupronickel", "pewter", "starsteel", "zinc", "mercury", "redstone");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            BMeThermalExpansion.addFurnace((String)materialName);
            BMeThermalExpansion.addCrucible((String)materialName);
            BMeThermalExpansion.addPlatePress((String)materialName);
            BMeThermalExpansion.addPressStorage((String)materialName);
            BMeThermalExpansion.addPulverizer((String)materialName);
        });
        MMDMaterial brass = Materials.getMaterialByName((String)"brass");
        MMDMaterial copper = Materials.getMaterialByName((String)"copper");
        MMDMaterial cupronickel = Materials.getMaterialByName((String)"cupronickel");
        MMDMaterial nickel = Materials.getMaterialByName((String)"nickel");
        MMDMaterial zinc = Materials.getMaterialByName((String)"zinc");
        MMDMaterial tin = Materials.getMaterialByName((String)"tin");
        MMDMaterial bronze = Materials.getMaterialByName((String)"bronze");
        if (BMeThermalExpansion.hasMaterials("copper", "zinc", "brass") && BMeThermalExpansion.materialsHaveItems(Arrays.asList("copper", "zinc", "brass"), Names.INGOT.toString())) {
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)copper.getItemStack(Names.INGOT, 2), (ItemStack)zinc.getItemStack(Names.INGOT, 1), (ItemStack)brass.getItemStack(Names.INGOT, 3));
        }
        if (BMeThermalExpansion.hasMaterials("copper", "nickel", "cupronickel") && BMeThermalExpansion.materialsHaveItems(Arrays.asList("copper", "nickel", "cupronickel"), Names.INGOT.toString())) {
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)copper.getItemStack(Names.INGOT, 3), (ItemStack)nickel.getItemStack(Names.INGOT, 1), (ItemStack)cupronickel.getItemStack(Names.INGOT, 4));
        }
        if (BMeThermalExpansion.hasMaterials("copper", "tin", "bronze") && BMeThermalExpansion.materialsHaveItems(Arrays.asList("copper", "tin", "bronze"), Names.INGOT.toString())) {
            ThermalExpansionHelper.addSmelterRecipe((int)4000, (ItemStack)copper.getItemStack(Names.INGOT, 3), (ItemStack)tin.getItemStack(Names.INGOT, 1), (ItemStack)bronze.getItemStack(Names.INGOT, 3));
        }
    }

    private static boolean materialsHaveItems(List<String> materialNames, String ... items) {
        for (String item : items) {
            for (String materialName : materialNames) {
                if (Materials.getMaterialByName((String)materialName).hasItem(item)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean hasMaterials(String ... materials) {
        for (String materialName : materials) {
            if (Materials.hasMaterial((String)materialName)) continue;
            return false;
        }
        return true;
    }
}

