/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.Mekanism;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MMDPlugin(addonId="basemetals", pluginId="mekanism")
public final class BMeMekanism
extends Mekanism
implements IIntegration {
    private static final List<String> materials = Arrays.asList("adamantine", "antimony", "bismuth", "coldiron", "platinum", "nickel", "starsteel", "zinc");

    public void init() {
        if (!Config.Options.isModEnabled((String)"mekanism")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        materials.stream().filter(Materials::hasMaterial).filter(BMeMekanism::isMaterialNotEmpty).forEach(Mekanism::addGassesForMaterial);
    }

    private static boolean isMaterialNotEmpty(@Nonnull String materialName) {
        return !Materials.getMaterialByName((String)materialName).isEmpty();
    }

    @SubscribeEvent
    public void regCallback(RegistryEvent.Register<IRecipe> event) {
        materials.stream().filter(Materials::hasMaterial).filter(BMeMekanism::isMaterialNotEmpty).forEach(Mekanism::addOreMultiplicationRecipes);
        if (Materials.hasMaterial((String)"diamond")) {
            this.addVanillaOreMultiplicationRecipes("diamond");
        }
        if (Materials.hasMaterial((String)"emerald")) {
            this.addVanillaOreMultiplicationRecipes("emerald");
        }
    }

    private void addVanillaOreMultiplicationRecipes(String materialName) {
        if (Materials.hasMaterial((String)materialName)) {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            if (material.hasBlock(Names.ORE) && material.hasItem(Names.INGOT)) {
                BMeMekanism.addCrusherRecipe((ItemStack)material.getBlockItemStack(Names.ORE), (ItemStack)material.getItemStack(Names.INGOT, 2));
            }
            if (material.hasItem(Names.INGOT) && material.hasItem(Names.POWDER)) {
                BMeMekanism.addCrusherRecipe((ItemStack)material.getItemStack(Names.INGOT), (ItemStack)material.getItemStack(Names.POWDER));
            }
            if (material.hasBlock(Names.ORE) && material.hasItem(Names.POWDER)) {
                BMeMekanism.addPurificationChamberRecipe((ItemStack)material.getBlockItemStack(Names.ORE), (ItemStack)material.getItemStack(Names.POWDER, 2));
            }
        }
    }
}

