/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.IntegrationInitEvent;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.IC2;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@MMDPlugin(addonId="basemetals", pluginId="ic2", versions="ic2@[2.8.57-ex112,)")
public final class BMeIC2
extends IC2
implements IIntegration {
    private static final List<String> materials = Arrays.asList("adamantine", "antimony", "bismuth", "coldiron", "platinum", "nickel", "starsteel", "zinc");

    public void init() {
        if (!Config.Options.isModEnabled((String)"ic2")) {
            return;
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void mainInteraction(RegistryEvent.Register<IRecipe> event) {
        String oreDictName;
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            this.registerVanillaRecipes((String)materialName);
            this.addMaceratorRecipes((String)materialName);
            this.addOreWashingPlantRecipes((String)materialName);
            this.addThermalCentrifugeRecipes((String)materialName);
            this.addMetalFormerRecipes((String)materialName);
            this.addCompressorRecipes((String)materialName);
        });
        if (Materials.hasMaterial((String)"diamond")) {
            MMDMaterial diamond = Materials.getMaterialByName((String)"diamond");
            oreDictName = diamond.getCapitalizedName();
            if (diamond.hasItem(Names.POWDER)) {
                this.addMaceratorRecipe("ore" + oreDictName, diamond.getItemStack(Names.POWDER, 2));
            }
        }
        if (Materials.hasMaterial((String)"emerald")) {
            MMDMaterial emerald = Materials.getMaterialByName((String)"emerald");
            oreDictName = emerald.getCapitalizedName();
            if (emerald.hasItem(Names.POWDER)) {
                this.addMaceratorRecipe("ore" + oreDictName, emerald.getItemStack(Names.POWDER, 2));
            }
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void doHammerRecipes(IntegrationInitEvent event) {
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(arg_0 -> ((BMeIC2)this).addForgeHammerRecipe(arg_0));
    }
}

