/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.EnderIO;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

@MMDPlugin(addonId="basemetals", pluginId="enderio")
public final class BMeEnderIO
extends EnderIO
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"enderio")) {
            return;
        }
        List<String> materials = Arrays.asList("adamantine", "antimony", "aquarium", "bismuth", "brass", "bronze", "coldiron", "cupronickel", "electrum", "invar", "mithril", "pewter", "platinum", "starsteel", "steel", "tin", "zinc");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> BMeEnderIO.addSagMillRecipe((String)materialName, (int)3600));
        BMeEnderIO.addSagMillRecipe((String)"copper", (int)2, (String)"gold", (int)1, (int)3600);
        BMeEnderIO.addSagMillRecipe((String)"lead", (int)2, (String)"silver", (int)1, (int)3600);
        BMeEnderIO.addSagMillRecipe((String)"nickel", (int)2, (String)"platinum", (int)1, (int)3600);
        BMeEnderIO.addSagMillRecipe((String)"silver", (int)2, (String)"lead", (int)1, (int)3600);
        BMeEnderIO.addSagMillRecipe((String)"iron", (int)2, (String)"nickel", (int)1, (int)3600);
        String COPPER = "Copper";
        String IRON = "Iron";
        String NICKEL = "Nickel";
        String SILVER = "Silver";
        String TIN = "Tin";
        String ZINC = "Zinc";
        List<Pair> alloys = Arrays.asList(Pair.of((Object)3, (Object)Triple.of((Object)"aquarium", (Object)20000, (Object)new Object[]{"ingotCopper", 2, "ingotZinc", 1, "dustPrismarine", 1})), Pair.of((Object)3, (Object)Triple.of((Object)"brass", (Object)2000, (Object)new Object[]{"ingotCopper", 2, "ingotZinc", 1})), Pair.of((Object)4, (Object)Triple.of((Object)"bronze", (Object)2000, (Object)new Object[]{"ingotCopper", 3, "ingotTin", 1})), Pair.of((Object)4, (Object)Triple.of((Object)"cupronickel", (Object)3000, (Object)new Object[]{"ingotCopper", 3, "ingotNickel", 1})), Pair.of((Object)3, (Object)Triple.of((Object)"invar", (Object)3000, (Object)new Object[]{"ingotIron", 2, "ingotNickel", 1})), Pair.of((Object)2, (Object)Triple.of((Object)"electrum", (Object)2000, (Object)new Object[]{"ingotGold", 1, "ingotSilver", 1})), Pair.of((Object)2, (Object)Triple.of((Object)"mithril", (Object)10000, (Object)new Object[]{"ingotSilver", 2, "ingotColdiron", 1, "ingotMercury", 1})), Pair.of((Object)3, (Object)Triple.of((Object)"pewter", (Object)2000, (Object)new Object[]{"ingotTin", 1, "ingotCopper", 1, "ingotLead", 1})), Pair.of((Object)8, (Object)Triple.of((Object)"steel", (Object)5000, (Object)new Object[]{"ingotIron", 8, "itemCoal", 1})));
        alloys.stream().filter(p -> Materials.hasMaterial((String)((String)((Triple)p.getRight()).getLeft()))).forEach(p -> {
            String name = (String)((Triple)p.getRight()).getLeft();
            int count = (Integer)p.getLeft();
            int cost = (Integer)((Triple)p.getRight()).getMiddle();
            Object[] recipe = (Object[])((Triple)p.getRight()).getRight();
            MMDMaterial material = Materials.getMaterialByName((String)name);
            BMeEnderIO.addAlloySmelterAlloy((MMDMaterial)material, (int)cost, (String)("ingot" + material.getCapitalizedName()), (int)count, (Object[])recipe);
        });
    }
}

