/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.integration.plugins;

import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.integration.IIntegration;
import com.mcmoddev.lib.integration.MMDPlugin;
import com.mcmoddev.lib.integration.plugins.DenseOres;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;

@MMDPlugin(addonId="basemetals", pluginId="denseores")
public final class BMeDenseOres
extends DenseOres
implements IIntegration {
    public void init() {
        if (!Config.Options.isModEnabled((String)"denseores")) {
            return;
        }
        BMeDenseOres.registerOres();
    }

    private static void registerOres() {
        List<String> materials = Arrays.asList("adamantine", "antimony", "bismuth", "coldiron", "copper", "lead", "mercury", "nickel", "platinum", "silver", "tin", "zinc");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            String baseMaterial;
            switch (materialName) {
                case "adamantine": 
                case "coldiron": {
                    baseMaterial = "netherrack";
                    break;
                }
                default: {
                    baseMaterial = "stone";
                }
            }
            BMeDenseOres.registerOre((String)String.format("%s_%s", materialName, "ore"), (String)baseMaterial, (int)0);
        });
    }
}

