/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.init;

import com.mcmoddev.basemetals.properties.BMEPropertiesHelper;
import com.mcmoddev.lib.block.InteractiveFluidBlock;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.events.MMDLibRegisterMaterials;
import com.mcmoddev.lib.material.IFluidBlockGetter;
import com.mcmoddev.lib.material.MMDMaterialType;
import com.mcmoddev.lib.util.Config;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fluids.FluidRegistry;

public final class Materials
extends com.mcmoddev.lib.init.Materials {
    private Materials() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    public static void init(MMDLibRegisterMaterials event) {
        List<String> rareMaterials = Arrays.asList("adamantine", "coldiron", "platinum", "starsteel");
        List<String> materials = Arrays.asList("antimony", "bismuth", "copper", "lead", "nickel", "silver", "tin", "zinc");
        List<String> rareAlloyMaterials = Arrays.asList("aquarium", "mithril");
        List<String> alloyMaterials = Arrays.asList("brass", "bronze", "cupronickel", "electrum", "invar", "pewter", "steel");
        materials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        alloyMaterials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createAlloyMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        rareMaterials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createRareMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        rareAlloyMaterials.stream().filter(Config.Options::isMaterialEnabled).forEach(name -> Materials.createRareAlloyMaterial((String)name, (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)Materials.getHardness(name), (double)Materials.getStrength(name), (double)Materials.getMagic(name), (int)Materials.getColor(name)));
        if (Config.Options.isMaterialEnabled((String)"mercury")) {
            Materials.createMaterial((String)"mercury", (MMDMaterialType.MaterialType)MMDMaterialType.MaterialType.METAL, (double)1.0, (double)1.0, (double)1.0, (int)-1907998, (boolean)true);
            Materials.getMaterialByName((String)"mercury").setFluidBlockGetter(new IFluidBlockGetter(){

                public BlockFluidClassic apply(String fluidName) {
                    return new InteractiveFluidBlock(FluidRegistry.getFluid((String)"mercury"), false, (w, e) -> {
                        if (w.field_73012_v.nextInt(32) == 0) {
                            e.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 600, 2));
                        }
                    });
                }
            });
        }
        if (Materials.hasMaterial((String)"adamantine")) {
            Materials.getMaterialByName((String)"adamantine").setBlastResistance(2000.0f).setSpawnSize(4).setDefaultDimension(-1);
        }
        if (Materials.hasMaterial((String)"starsteel")) {
            Materials.getMaterialByName((String)"starsteel").setBlastResistance(2000.0f).setSpawnSize(6).setDefaultDimension(1).setRegenerates(true);
        }
    }

    public static void initTooltips() {
        Arrays.asList("adamantine", "coldiron", "aquarium", "mithril").stream().filter(Config.Options::isMaterialEnabled).forEach(mn -> {
            Arrays.asList(Names.HELMET, Names.CHESTPLATE, Names.LEGGINGS, Names.BOOTS).stream().forEach(n -> Materials.getMaterialByName((String)mn).addTooltipFor(n, BMEPropertiesHelper.addArmorSpecialPropertiesToolTip(mn)));
            Arrays.asList(Names.values()).stream().filter(n -> n != Names.HELMET && n != Names.CHESTPLATE && n != Names.LEGGINGS && n != Names.BOOTS).forEach(n -> Materials.getMaterialByName((String)mn).addTooltipFor(n, BMEPropertiesHelper.addToolSpecialPropertiesToolTip(mn)));
        });
    }

    private static int getColor(@Nonnull String name) {
        switch (name) {
            case "adamantine": {
                return -11323073;
            }
            case "antimony": {
                return -2563106;
            }
            case "aquarium": {
                return -16776961;
            }
            case "bismuth": {
                return -2238517;
            }
            case "brass": {
                return -7308;
            }
            case "bronze": {
                return -547505;
            }
            case "coldiron": {
                return -3682576;
            }
            case "copper": {
                return -24712;
            }
            case "cupronickel": {
                return -3626129;
            }
            case "electrum": {
                return -3405;
            }
            case "invar": {
                return -2961992;
            }
            case "lead": {
                return -8684677;
            }
            case "mithril": {
                return -720897;
            }
            case "nickel": {
                return -1114133;
            }
            case "pewter": {
                return -7170401;
            }
            case "platinum": {
                return -851969;
            }
            case "silver": {
                return -1;
            }
            case "starsteel": {
                return -11323073;
            }
            case "steel": {
                return -2759707;
            }
            case "tin": {
                return -2066;
            }
            case "zinc": {
                return -4408132;
            }
        }
        return 0;
    }

    private static double getMagic(@Nonnull String name) {
        switch (name) {
            case "platinum": 
            case "aquarium": {
                return 15.0;
            }
            case "starsteel": {
                return 12.0;
            }
            case "electrum": {
                return 10.0;
            }
            case "mithril": 
            case "brass": {
                return 9.0;
            }
            case "nickel": 
            case "coldiron": {
                return 7.0;
            }
            case "silver": 
            case "cupronickel": {
                return 6.0;
            }
            case "copper": {
                return 5.0;
            }
            case "bronze": {
                return 4.5;
            }
            case "invar": {
                return 3.0;
            }
            case "tin": 
            case "steel": {
                return 2.0;
            }
            case "antimony": 
            case "bismuth": 
            case "lead": 
            case "pewter": 
            case "zinc": {
                return 1.0;
            }
            case "adamantine": {
                return 0.0;
            }
        }
        return 1.0;
    }

    private static double getStrength(@Nonnull String name) {
        switch (name) {
            case "adamantine": {
                return 100.0;
            }
            case "starsteel": {
                return 25.0;
            }
            case "steel": {
                return 15.0;
            }
            case "invar": 
            case "aquarium": {
                return 10.0;
            }
            case "mithril": {
                return 9.0;
            }
            case "coldiron": {
                return 7.0;
            }
            case "cupronickel": {
                return 6.0;
            }
            case "platinum": {
                return 5.0;
            }
            case "silver": 
            case "nickel": 
            case "electrum": 
            case "copper": 
            case "bronze": {
                return 4.0;
            }
            case "brass": {
                return 3.0;
            }
        }
        return 1.0;
    }

    private static double getHardness(@Nonnull String name) {
        switch (name) {
            case "adamantine": {
                return 12.0;
            }
            case "starsteel": {
                return 10.0;
            }
            case "invar": 
            case "mithril": {
                return 9.0;
            }
            case "steel": 
            case "bronze": {
                return 8.0;
            }
            case "coldiron": {
                return 7.0;
            }
            case "cupronickel": {
                return 6.0;
            }
            case "silver": 
            case "electrum": {
                return 5.0;
            }
            case "copper": 
            case "aquarium": 
            case "nickel": {
                return 4.0;
            }
            case "brass": {
                return 3.5;
            }
            case "tin": 
            case "platinum": {
                return 3.0;
            }
        }
        return 1.0;
    }
}

