/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.init;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.events.MMDLibRegisterItems;
import com.mcmoddev.lib.init.ItemGroups;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.IMMDBurnableObject;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.util.Oredicts;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(modid="basemetals")
public final class Items
extends com.mcmoddev.lib.init.Items {
    private Items() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    @SubscribeEvent
    public static void registerItems(MMDLibRegisterItems ev) {
        List<String> materials = Arrays.asList("adamantine", "antimony", "aquarium", "bismuth", "brass", "bronze", "coldiron", "copper", "cupronickel", "electrum", "invar", "lead", "mithril", "nickel", "pewter", "platinum", "silver", "starsteel", "steel", "tin", "zinc");
        List<String> materialsModSupport = Arrays.asList("adamantine", "antimony", "bismuth", "coldiron", "platinum", "nickel", "starsteel", "zinc");
        materials.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            Items.create((Names)Names.BLEND, (MMDMaterial)material);
            Items.create((Names)Names.INGOT, (MMDMaterial)material);
            Items.create((Names)Names.NUGGET, (MMDMaterial)material);
            Items.create((Names)Names.POWDER, (MMDMaterial)material);
            Items.create((Names)Names.SMALLBLEND, (MMDMaterial)material);
            Items.create((Names)Names.SMALLPOWDER, (MMDMaterial)material);
            Items.create((Names)Names.ARROW, (MMDMaterial)material);
            Items.create((Names)Names.AXE, (MMDMaterial)material);
            Items.create((Names)Names.BOLT, (MMDMaterial)material);
            Items.create((Names)Names.BOOTS, (MMDMaterial)material);
            Items.create((Names)Names.BOW, (MMDMaterial)material);
            Items.create((Names)Names.CHESTPLATE, (MMDMaterial)material);
            Items.create((Names)Names.CRACKHAMMER, (MMDMaterial)material);
            Items.create((Names)Names.CROSSBOW, (MMDMaterial)material);
            Items.create((Names)Names.DOOR, (MMDMaterial)material);
            Items.create((Names)Names.FISHING_ROD, (MMDMaterial)material);
            Items.create((Names)Names.HELMET, (MMDMaterial)material);
            Items.create((Names)Names.HOE, (MMDMaterial)material);
            Items.create((Names)Names.HORSE_ARMOR, (MMDMaterial)material);
            Items.create((Names)Names.LEGGINGS, (MMDMaterial)material);
            Items.create((Names)Names.PICKAXE, (MMDMaterial)material);
            Items.create((Names)Names.SHEARS, (MMDMaterial)material);
            Items.create((Names)Names.SHIELD, (MMDMaterial)material);
            Items.create((Names)Names.SHOVEL, (MMDMaterial)material);
            Items.create((Names)Names.SCYTHE, (MMDMaterial)material);
            Items.create((Names)Names.SLAB, (MMDMaterial)material);
            Items.create((Names)Names.SWORD, (MMDMaterial)material);
            Items.create((Names)Names.ROD, (MMDMaterial)material);
            Items.create((Names)Names.GEAR, (MMDMaterial)material);
        });
        materials.stream().filter(Materials::hasMaterial).map(Materials::getMaterialByName).forEach(Items::setBurnTimes);
        materialsModSupport.stream().filter(Materials::hasMaterial).filter(materialName -> !Materials.getMaterialByName((String)materialName).isEmpty()).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            Items.create((Names)Names.CASING, (MMDMaterial)material);
            Items.create((Names)Names.DENSE_PLATE, (MMDMaterial)material);
            if (material.hasOre()) {
                Items.create((Names)Names.CRUSHED, (MMDMaterial)material);
                Items.create((Names)Names.CRUSHED_PURIFIED, (MMDMaterial)material);
                Items.createMekCrystal((MMDMaterial)material, (CreativeTabs)ItemGroups.getTab((String)"items"));
                Items.create((Names)Names.SHARD, (MMDMaterial)material);
                Items.create((Names)Names.CLUMP, (MMDMaterial)material);
                Items.create((Names)Names.POWDER_DIRTY, (MMDMaterial)material);
                Items.create((Names)Names.CRYSTAL, (MMDMaterial)material);
            }
        });
        if (Materials.hasMaterial((String)"mercury")) {
            MMDMaterial mercury = Materials.getMaterialByName((String)"mercury");
            Items.create((Names)Names.INGOT, (MMDMaterial)mercury);
            Items.create((Names)Names.NUGGET, (MMDMaterial)mercury);
            Items.create((Names)Names.POWDER, (MMDMaterial)mercury);
            Items.create((Names)Names.SMALLPOWDER, (MMDMaterial)mercury);
        }
        Arrays.asList("stone", "steel", "adamantine").stream().filter(Materials::hasMaterial).forEach(materialName -> Items.create((Names)Names.ANVIL, (MMDMaterial)Materials.getMaterialByName((String)materialName)));
        Items.addToMetList();
        MinecraftForge.EVENT_BUS.register(Items.class);
    }

    private static void setBurnTimes(@Nonnull MMDMaterial material) {
        if (material.hasItem(Names.NUGGET)) {
            ((IMMDBurnableObject)material.getItem(Names.NUGGET)).setBurnTime(200);
        }
        if (material.hasItem(Names.POWDER)) {
            ((IMMDBurnableObject)material.getItem(Names.POWDER)).setBurnTime(1600);
        }
        if (material.hasItem(Names.SMALLPOWDER)) {
            ((IMMDBurnableObject)material.getItem(Names.SMALLPOWDER)).setBurnTime(200);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Materials.getAllMaterials().stream().filter(mat -> !mat.isVanilla()).forEach(mat -> Items.regItems((IForgeRegistry<Item>)event.getRegistry(), (ImmutableList<ItemStack>)mat.getItems()));
        Oredicts.registerItemOreDictionaryEntries();
        Oredicts.registerBlockOreDictionaryEntries();
    }

    private static void regItems(IForgeRegistry<Item> registry, ImmutableList<ItemStack> items) {
        items.stream().filter(Items::isThisMod).map(Items::getItem).forEach(arg_0 -> registry.register(arg_0));
    }

    private static Item getItem(ItemStack it) {
        return it.func_77973_b();
    }

    private static boolean isThisMod(ItemStack it) {
        return it.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("basemetals");
    }
}

