/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals.init;

import com.google.common.collect.ImmutableList;
import com.mcmoddev.lib.block.BlockHumanDetector;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.events.MMDLibRegisterBlocks;
import com.mcmoddev.lib.init.ItemGroups;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="basemetals")
public final class Blocks
extends com.mcmoddev.lib.init.Blocks {
    private Blocks() {
        throw new IllegalAccessError("Not a instantiable class");
    }

    @SubscribeEvent
    public static void init(MMDLibRegisterBlocks event) {
        List<String> materials = Arrays.asList("adamantine", "antimony", "aquarium", "bismuth", "brass", "bronze", "coldiron", "copper", "cupronickel", "electrum", "invar", "lead", "mithril", "nickel", "pewter", "platinum", "silver", "starsteel", "steel", "tin", "zinc");
        materials.stream().filter(Materials::hasMaterial).forEach(materialName -> {
            MMDMaterial material = Materials.getMaterialByName((String)materialName);
            Blocks.create((Names)Names.BLOCK, (MMDMaterial)material);
            Blocks.create((Names)Names.PLATE, (MMDMaterial)material);
            Blocks.create((Names)Names.ORE, (MMDMaterial)material);
            Blocks.create((Names)Names.BARS, (MMDMaterial)material);
            Blocks.create((Names)Names.DOOR, (MMDMaterial)material);
            Blocks.create((Names)Names.TRAPDOOR, (MMDMaterial)material);
            Blocks.create((Names)Names.BUTTON, (MMDMaterial)material);
            Blocks.create((Names)Names.SLAB, (MMDMaterial)material);
            Blocks.create((Names)Names.DOUBLE_SLAB, (MMDMaterial)material);
            Blocks.create((Names)Names.LEVER, (MMDMaterial)material);
            Blocks.create((Names)Names.PRESSURE_PLATE, (MMDMaterial)material);
            Blocks.create((Names)Names.STAIRS, (MMDMaterial)material);
            Blocks.create((Names)Names.WALL, (MMDMaterial)material);
        });
        Blocks.createMercury();
        Blocks.createAnvils();
        Blocks.addBlock((Block)new BlockHumanDetector(), (String)"human_detector", (CreativeTabs)ItemGroups.getTab((String)"blocks"));
        MinecraftForge.EVENT_BUS.register(Blocks.class);
    }

    private static void createAnvils() {
        Arrays.asList("stone", "steel", "adamantine").stream().filter(Materials::hasMaterial).forEach(name -> Blocks.create((Names)Names.ANVIL, (MMDMaterial)Materials.getMaterialByName((String)name)));
    }

    private static void createMercury() {
        if (Materials.hasMaterial((String)"mercury")) {
            MMDMaterial mercury = Materials.getMaterialByName((String)"mercury");
            Blocks.create((Names)Names.ORE, (MMDMaterial)mercury);
            if (mercury.hasBlock(Names.ORE)) {
                mercury.getBlock(Names.ORE).func_149711_c(3.0f).func_149752_b(5.0f);
            }
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        Materials.getMaterialsByMod((String)"basemetals").stream().filter(mat -> !mat.isVanilla()).forEach(mat -> Blocks.regBlocks((IForgeRegistry<Block>)event.getRegistry(), (ImmutableList<Block>)mat.getBlocks()));
        event.getRegistry().register((IForgeRegistryEntry)Materials.DEFAULT.getBlock("human_detector"));
    }

    private static void regBlocks(IForgeRegistry<Block> registry, ImmutableList<Block> blocks) {
        blocks.stream().filter(block -> block.getRegistryName().func_110624_b().equals("basemetals")).forEach(arg_0 -> registry.register(arg_0));
    }
}

