/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.basemetals;

import com.mcmoddev.basemetals.BaseMetals;
import com.mcmoddev.lib.data.Names;
import com.mcmoddev.lib.init.Materials;
import com.mcmoddev.lib.material.MMDMaterial;
import com.mcmoddev.lib.registry.CrusherRecipeRegistry;
import com.mcmoddev.lib.registry.recipe.ICrusherRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ModelDataFix {
    private static List<String> vanilla_names = Arrays.asList("charcoal", "coal", "diamond", "emerald", "ender", "gold", "iron", "lapis", "obsidian", "prismarine", "quartz", "wood", "redstone", "stone", "redstone");

    @SubscribeEvent
    public static void blockRegistryFix(RegistryEvent.MissingMappings<Block> ev) {
        ev.getAllMappings().stream().filter(mapping -> mapping.key.func_110624_b().equalsIgnoreCase("mmdlib")).filter(mapping -> {
            String[] pathBits = mapping.key.func_110623_a().split("_");
            String matName = "double".equalsIgnoreCase(pathBits[0]) ? pathBits[1] : pathBits[0];
            return vanilla_names.contains(mapping.key.func_110623_a().indexOf("_") != -1 ? matName : mapping.key.func_110623_a()) || "human_detector".equalsIgnoreCase(mapping.key.func_110623_a());
        }).forEach(mapping -> {
            BaseMetals.logger.fatal("mapping: {}", (Object)mapping.key);
            if (mapping.key.func_110623_a().indexOf("_") != -1) {
                String p = mapping.key.func_110623_a();
                int idx = mapping.key.func_110623_a().indexOf("_");
                String materialName = p.substring(0, idx);
                String blockName = p.substring(idx + 1);
                if ("double".equals(materialName)) {
                    materialName = blockName.split("_")[0];
                    blockName = Names.DOUBLE_SLAB.toString();
                }
                mapping.remap((IForgeRegistryEntry)Materials.getMaterialByName((String)materialName).getBlock(blockName));
            } else {
                mapping.remap((IForgeRegistryEntry)Materials.getMaterialByName((String)mapping.key.func_110623_a()).getBlock("fluid"));
            }
        });
    }

    @SubscribeEvent
    public static void itemRegistryFix(RegistryEvent.MissingMappings<Item> ev) {
        ev.getAllMappings().stream().filter(mapping -> mapping.key.func_110624_b().equalsIgnoreCase("mmdlib")).filter(mapping -> {
            String[] pathBits = mapping.key.func_110623_a().split("_");
            return vanilla_names.contains(mapping.key.func_110623_a().indexOf("_") != -1 ? pathBits[0] : mapping.key.func_110623_a());
        }).forEach(mapping -> {
            ResourceLocation remap = new ResourceLocation("basemetals", mapping.key.func_110623_a());
            mapping.remap(ForgeRegistries.ITEMS.getValue(remap));
        });
    }

    @SubscribeEvent
    public static void materialRegistryFix(RegistryEvent.MissingMappings<MMDMaterial> ev) {
        ev.getAllMappings().stream().filter(mapping -> mapping.key.func_110624_b().equalsIgnoreCase("mmdlib")).filter(mapping -> vanilla_names.contains(mapping.key.func_110623_a()) || "default".equals(mapping.key.func_110623_a()) || "empty".equals(mapping.key.func_110623_a())).forEach(mapping -> mapping.remap((IForgeRegistryEntry)Materials.getMaterialByName((String)mapping.key.func_110623_a())));
    }

    @SubscribeEvent
    public static void crusherRecipeRegistryFix(RegistryEvent.MissingMappings<ICrusherRecipe> ev) {
        ev.getAllMappings().stream().filter(mapping -> mapping.key.func_110624_b().equalsIgnoreCase("mmdlib")).forEach(mapping -> {
            ResourceLocation remap = new ResourceLocation("basemetals", mapping.key.func_110623_a());
            ICrusherRecipe recipeRemap = (ICrusherRecipe)CrusherRecipeRegistry.getInstance().getRegistry().getValue(remap);
            if (recipeRemap != null) {
                mapping.remap((IForgeRegistryEntry)recipeRemap);
            }
        });
    }
}

