/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.fishing;

import com.polipo.fishing.BlockDynamicNetWet;
import com.polipo.fishing.BlockNetDry;
import com.polipo.fishing.BlockStaticNetWet;
import com.polipo.fishing.FishingNet;
import com.polipo.fishing.advancements.Triggers;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityNet
extends TileEntity
implements IInventory {
    public static final float AVERAGE_FISHING_RATE = 8.0f;
    int speedBonus;
    int itemsCount;
    int facing;
    long lastUpdate;
    int hopperCooldown;
    ItemStack stackInslot = ItemStack.field_190927_a;
    long lastHopperPull;

    public TileEntityNet(long l) {
        this.facing = (int)(Math.random() * 256.0);
        this.lastUpdate = l;
    }

    public TileEntityNet() {
        this.facing = (int)(Math.random() * 256.0);
    }

    protected void func_190201_b(World worldIn) {
        super.func_190201_b(worldIn);
        this.lastUpdate = worldIn.func_82737_E();
    }

    public void update() {
        this.lastUpdate = this.field_145850_b.func_82737_E();
        if (this.itemsCount == 0) {
            this.facing = (int)(Math.random() * 256.0);
        }
        if (this.isFull()) {
            return;
        }
        int pathLength = this.itemsCount + 1;
        BlockPos blockPos = this.field_174879_c;
        EnumFacing direction = EnumFacing.func_176741_a((Random)this.field_145850_b.field_73012_v);
        while (pathLength-- > 0) {
            blockPos = blockPos.func_177972_a(direction);
            EnumFacing newDirection = EnumFacing.func_176741_a((Random)this.field_145850_b.field_73012_v);
            if (newDirection == direction.func_176734_d()) {
                newDirection = direction;
            }
            direction = newDirection;
            IBlockState blockState = this.field_145850_b.func_180495_p(blockPos);
            if (blockState.func_185904_a() == Material.field_151586_h) continue;
            return;
        }
        ++this.itemsCount;
        this.resetHopperCooldown();
        this.playSplash();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
        this.func_70296_d();
    }

    public boolean increaseRate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block == FishingNet.netWetStatic && this.speedBonus < 3) {
            ++this.speedBonus;
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FishingNet.baitEvt, SoundCategory.AMBIENT, 0.2f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
            ((BlockStaticNetWet)FishingNet.netWetStatic).scheduleNextUpdate(this.field_145850_b, this.field_174879_c, state, this);
            return true;
        }
        return false;
    }

    boolean isFull() {
        return this.itemsCount >= 10;
    }

    @SideOnly(value=Side.CLIENT)
    public void sbonzola(int num) {
        for (int i = 0; i < num; ++i) {
            this.field_145850_b.func_175688_a(EnumParticleTypes.WATER_BUBBLE, (double)((float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat()), (double)((float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat()), (double)(-0.5f + this.field_145850_b.field_73012_v.nextFloat()), (double)(-0.5f + this.field_145850_b.field_73012_v.nextFloat()), (double)(-0.5f + this.field_145850_b.field_73012_v.nextFloat()), new int[0]);
        }
    }

    private void playSplash() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        Block block = state.func_177230_c();
        if (block instanceof BlockDynamicNetWet || block instanceof BlockStaticNetWet) {
            this.field_145850_b.func_184148_a((EntityPlayer)null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), FishingNet.splashEvt, SoundCategory.AMBIENT, 1.25f, 1.0f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f);
        }
    }

    public void dropItems(World worldIn, BlockPos pos) {
        this.dropItems(worldIn, pos, null);
    }

    public void dropItems(World worldIn, BlockPos pos, EntityPlayer player) {
        this.playSplash();
        if (!worldIn.field_72995_K && !worldIn.restoringBlockSnapshots) {
            float luck;
            int looting;
            int fortune;
            int silkTouch;
            int sharpness;
            if (player != null) {
                ItemStack heldItem = player.func_184586_b(EnumHand.MAIN_HAND);
                sharpness = (int)((float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185302_k, (ItemStack)heldItem) * 0.8f);
                silkTouch = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)heldItem);
                fortune = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)heldItem);
                looting = EnchantmentHelper.func_185283_h((EntityLivingBase)player);
                luck = (float)EnchantmentHelper.func_191529_b((ItemStack)heldItem) + player.func_184817_da();
            } else {
                sharpness = 0;
                looting = 0;
                fortune = 0;
                silkTouch = 0;
                luck = 0;
            }
            if (silkTouch > 0 || (double)this.field_145850_b.field_73012_v.nextFloat() < 0.7 - (double)sharpness * 0.1) {
                Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Item)FishingNet.itemNet));
                this.playSplash();
            } else {
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), FishingNet.snatchEvt, SoundCategory.AMBIENT, 0.07f, 0.6f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
            }
            float countModifier = 1.0f + (float)(looting + fortune) / 5.0f;
            int newItemsCount = (int)Math.ceil((float)this.itemsCount * countModifier);
            this.itemsCount = 0;
            boolean magic = false;
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            lootcontext$builder.func_186469_a(luck);
            while (newItemsCount-- > 0) {
                for (ItemStack itemstack : this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(worldIn.field_73012_v, lootcontext$builder.func_186471_a())) {
                    if (itemstack.func_77973_b() instanceof ItemEnchantedBook) {
                        magic = true;
                    }
                    Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)itemstack);
                }
            }
            if (magic && player != null) {
                Triggers.MAGIC.trigger((EntityPlayerMP)player);
            }
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if ((oldState.func_177230_c() instanceof BlockNetDry || oldState.func_177230_c() instanceof BlockStaticNetWet || oldState.func_177230_c() instanceof BlockDynamicNetWet) && (newState.func_177230_c() instanceof BlockNetDry || newState.func_177230_c() instanceof BlockStaticNetWet || newState.func_177230_c() instanceof BlockDynamicNetWet)) {
            return false;
        }
        if ((oldState.func_177230_c() instanceof BlockNetDry || oldState.func_177230_c() instanceof BlockStaticNetWet || oldState.func_177230_c() instanceof BlockDynamicNetWet) && !(newState.func_177230_c() instanceof BlockNetDry) && !(newState.func_177230_c() instanceof BlockStaticNetWet) && !(newState.func_177230_c() instanceof BlockDynamicNetWet)) {
            return true;
        }
        return super.shouldRefresh(world, pos, oldState, newState);
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = compound.func_74771_c("Facing") & 0xFF;
        this.itemsCount = compound.func_74771_c("ItemsCount") & 0xFF;
        this.speedBonus = compound.func_74771_c("SpeedBonus") & 0xFF;
        this.lastUpdate = compound.func_74763_f("LastUpdate");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74774_a("Facing", (byte)this.facing);
        compound.func_74774_a("ItemsCount", (byte)this.itemsCount);
        compound.func_74774_a("SpeedBonus", (byte)this.speedBonus);
        this.lastUpdate = compound.func_74763_f("LastUpdate");
        return compound;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound compound = super.func_189517_E_();
        compound.func_74774_a("Facing", (byte)this.facing);
        compound.func_74774_a("ItemsCount", (byte)this.itemsCount);
        compound.func_74774_a("SpeedBonus", (byte)this.speedBonus);
        compound.func_74772_a("LastUpdate", this.lastUpdate);
        return compound;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        int oldItemsCount = this.itemsCount;
        this.func_145839_a(pkt.func_148857_g());
        if (this.itemsCount != oldItemsCount) {
            this.sbonzola(4);
        } else {
            this.sbonzola(1);
        }
    }

    public String func_70005_c_() {
        return this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c().func_149732_F();
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return 1;
    }

    public boolean func_191420_l() {
        return this.itemsCount > 0;
    }

    public ItemStack func_70301_a(int index) {
        if (index == 0 && this.itemsCount > 0 && this.hopperCooldown-- < 1) {
            if (!this.stackInslot.func_190926_b()) {
                return this.stackInslot;
            }
            LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)this.field_145850_b);
            List loots = this.field_145850_b.func_184146_ak().func_186521_a(LootTableList.field_186387_al).func_186462_a(this.field_145850_b.field_73012_v, lootcontext$builder.func_186471_a());
            if (loots.size() > 0) {
                ((ItemStack)loots.get(0)).func_190920_e(1);
                this.stackInslot = (ItemStack)loots.get(0);
                return this.stackInslot;
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        if (index == 0 && this.itemsCount > 0) {
            this.lastHopperPull = this.field_145850_b.func_72820_D();
            ItemStack ret = this.stackInslot;
            this.stackInslot = ItemStack.field_190927_a;
            --this.itemsCount;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
            this.func_70296_d();
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (index == 0 && this.itemsCount > 0) {
            this.lastHopperPull = this.field_145850_b.func_72820_D();
            ItemStack ret = this.stackInslot;
            this.stackInslot = ItemStack.field_190927_a;
            --this.itemsCount;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
            this.func_70296_d();
            return ret;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.lastHopperPull == this.field_145850_b.func_72820_D()) {
            this.lastHopperPull = -1L;
            this.resetHopperCooldown();
            ++this.itemsCount;
            this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 0);
            this.func_70296_d();
        }
    }

    private void resetHopperCooldown() {
        this.hopperCooldown = (int)(960.0f * (0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.4f));
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

