/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.coremod.hooks.BlockRandomTickHook;
import com.endertech.minecraft.forge.coremod.hooks.BlockStateChangeHook;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Collector;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class WorldData {
    static final Map<World, WorldData> DATA_MAP = new ConcurrentHashMap<World, WorldData>();
    final SmokeLocations smokeLocations = new SmokeLocations();
    final World world;

    public WorldData(World world) {
        this.world = world;
    }

    @Nonnull
    public static WorldData getData(World world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            DATA_MAP.put(world, data);
        }
        return data;
    }

    @Deprecated
    public static Smoke collectSmokeAround(World world, BlockPos startPos) {
        Collector collector = new Collector();
        List positions = ForgeWorld.Position.getAroundHoriz((BlockPos)startPos, (boolean)false, (BlockPos[])new BlockPos[0]);
        for (BlockPos pos : positions) {
            Smoke smoke = Smoke.getNone();
            Emitter emitter = Main.getEmitters().findBy(world, pos);
            if (emitter == null) continue;
            smoke = emitter.getSmoke(world, pos, false, true);
            collector.addSmoke(smoke);
        }
        return collector.getSmoke();
    }

    public float getParticlesReductionFactor() {
        float factor = 1.0f;
        int particlesCount = ForgeWorld.getData((World)this.getWorld()).smokeParticlesCount;
        if (particlesCount > Smoke.maxRenderedParticlesAmount) {
            factor = (float)Smoke.maxRenderedParticlesAmount / (float)particlesCount;
        }
        return factor;
    }

    public void updateSmokeEmitterAt(BlockPos emitterPos) {
        if (ForgeWorld.isClientSide((World)this.world)) {
            return;
        }
        if (emitterPos instanceof BlockPos.MutableBlockPos) {
            return;
        }
        if (!this.world.func_175667_e(emitterPos)) {
            this.getSmokeLocations().remove(emitterPos);
            return;
        }
        Emitter emitter = Main.getEmitters().findBy(this.world, emitterPos);
        Smoke emitterSmoke = this.getSmokeLocations().get(emitterPos);
        if (emitter != null) {
            this.world.field_72984_F.func_76320_a("updateSmokeEmitter");
            if (emitterSmoke == null || emitterSmoke.getLifeTime().moreThan(Events.serverToClientUpdateInterval.getInterval())) {
                Smoke outletSmoke;
                int outletsCount;
                emitterSmoke = emitter.getSmoke(this.world, emitterPos, true, true);
                ArrayList<BlockPos> outlets = new ArrayList<BlockPos>();
                int maxOutletsAmount = (int)emitterSmoke.getAmount();
                WorldSearch.VentPipe.PumpFunc addOutlets = (worldIn, posIn, maxAmount) -> {
                    outlets.add(posIn);
                    return 1;
                };
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((World)this.world, (BlockPos)emitterPos, (Set)emitter.getRelatedBlocks());
                WorldSearch.VentPipe.pump((World)this.world, (List)neighbors.getActiveVents(), (int)maxOutletsAmount, (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                if (outlets.isEmpty()) {
                    outlets.addAll(neighbors.getTopChimneys());
                }
                if (emitter.canEmitAside()) {
                    outlets.addAll(neighbors.getSideChimneys());
                    if (outlets.isEmpty()) {
                        WorldSearch.VentPipe.pump((World)this.world, (List)neighbors.getPassiveVents(), (int)maxOutletsAmount, (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    }
                }
                if ((outletsCount = Math.min(outlets.size(), maxOutletsAmount)) == 0 && emitter.emitWithoutChimney()) {
                    outlets.add(emitterPos);
                    outletsCount = outlets.size();
                }
                this.getSmokeLocations().add(emitterPos, emitterSmoke);
                if (outletsCount > 0 && (outletSmoke = emitterSmoke.devideInto(outletsCount)).hasParticles()) {
                    int count = 1;
                    for (BlockPos pos : outlets) {
                        if (count > outletsCount) break;
                        SmokePosMsg message = new SmokePosMsg(pos, outletSmoke);
                        Main.instance.getConnection().sendToAllAround((IMessage)message, this.world, pos, Smoke.maxRenderDistance);
                        ++count;
                    }
                }
            }
            this.world.field_72984_F.func_76319_b();
        } else if (emitterSmoke != null) {
            this.getSmokeLocations().remove(emitterPos);
        }
    }

    public World getWorld() {
        return this.world;
    }

    public SmokeLocations getSmokeLocations() {
        return this.smokeLocations;
    }

    @Deprecated
    public void meltSnowAround(BlockPos pos, Smoke smoke) {
        if (ForgeWorld.isServerSide((World)this.world)) {
            BlockPos startPos;
            boolean shouldMelt;
            boolean bl = shouldMelt = CommonMath.Random.between((float)0.0f, (float)Smoke.maxAmount) < smoke.getAmount();
            if (shouldMelt && (startPos = (BlockPos)CommonMath.Random.from((List)ForgeWorld.Position.getAroundHoriz((BlockPos)pos, (boolean)true, (BlockPos[])new BlockPos[0]))) != null) {
                int maxOffset = Math.max(1, Math.round(smoke.getIntencity()));
                for (int offset = 0; offset <= maxOffset; ++offset) {
                    BlockPos snowPos = startPos.func_177981_b(offset);
                    if (ForgeWorld.SnowMelter.isSnow((World)this.world, (BlockPos)snowPos)) {
                        ForgeWorld.SnowMelter.meltLayerAt((World)this.world, (BlockPos)snowPos);
                        break;
                    }
                    BlockPos checkPos = pos.func_177981_b(offset + 1);
                    Block block = this.world.func_180495_p(checkPos).func_177230_c();
                    if (ForgeWorld.SmokeContainers.isChimney((World)this.world, (BlockPos)checkPos) || ForgeWorld.isVerticalOpaque((World)this.world, (BlockPos)checkPos) || block == Blocks.field_150359_w || block == Blocks.field_150399_cn) break;
                }
            }
        }
    }

    public static class BlockStateChange
    extends BlockStateChangeHook {
        public static void handle(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
            WorldData.getData(world).updateSmokeEmitterAt(pos);
        }
    }

    public static class BlockRandomTick
    extends BlockRandomTickHook {
        @Nullable
        public static Boolean handle(World world, BlockPos pos) {
            WorldData.getData(world).updateSmokeEmitterAt(pos);
            return null;
        }
    }
}

