/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adchimneys.smoke.Renderer;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import com.endertech.minecraft.mods.adchimneys.world.WorldListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber
public class Events {
    public static GameTime serverUpdateInterval = GameTime.second();
    public static GameTime serverToClientUpdateInterval = GameTime.second();
    public static GameTime clientUpdateInterval = GameTime.quaterSecond();
    public static GameTime clientWaitForUpdateTime = GameTime.seconds((int)2);

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        World world = event.getWorld();
        if (ForgeWorld.isServerSide((World)world)) {
            Chunk chunk = event.getChunk();
            ArrayList tileEntities = new ArrayList(chunk.func_177434_r().values());
            for (TileEntity tile : tileEntities) {
                world = tile.func_145831_w();
                if (!ForgeWorld.isServerSide((World)world)) continue;
                WorldData.getData(world).updateSmokeEmitterAt(tile.func_174877_v());
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER && serverUpdateInterval.pastIn(world)) {
            WorldData data = WorldData.getData(world);
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = data.getSmokeLocations().getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                if (!smoke.getLifeTime().moreThan(serverToClientUpdateInterval.getInterval())) continue;
                data.updateSmokeEmitterAt(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        World world = event.player.func_130014_f_();
        if (event.phase == TickEvent.Phase.END && event.side == Side.CLIENT && clientUpdateInterval.pastIn(world)) {
            WorldData data = WorldData.getData(world);
            SmokeLocations locations = data.getSmokeLocations();
            Iterator<Map.Entry<BlockPos, Smoke>> iterator = locations.getEntrySetIterator();
            while (iterator.hasNext()) {
                Map.Entry<BlockPos, Smoke> entry = iterator.next();
                BlockPos pos = entry.getKey();
                Smoke smoke = entry.getValue();
                double distance = ForgeEntity.getCurPosition((Entity)Minecraft.func_71410_x().func_175606_aa()).distance(Vect3d.from((BlockPos)pos));
                float totalParticlesAmount = locations.getTotalParticlesAmount();
                if (totalParticlesAmount > 0.0f && smoke.hasParticles() && smoke.getLifeTime().lessThan(clientWaitForUpdateTime.getInterval()) && distance <= (double)Smoke.maxRenderDistance && (Smoke.emitWithoutChimney || ForgeWorld.SmokeContainers.isChimney((World)world, (BlockPos)pos))) {
                    float emittionFactor = locations.getParticlesReductionFactor();
                    float renderFactor = data.getParticlesReductionFactor();
                    IWind wind = ForgeWorld.getWindAt((World)world, (BlockPos)pos);
                    Renderer.renderSmoke(world, wind, smoke, pos, Math.min(emittionFactor, renderFactor));
                    continue;
                }
                locations.remove(pos);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (ForgeWorld.isServerSide((World)world)) {
            WorldListener listener = new WorldListener();
            world.func_72954_a((IWorldEventListener)listener);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        WorldData.DATA_MAP.remove(world);
    }
}

