/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.ModConfigGui;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.TileEntityPump;
import com.endertech.minecraft.mods.adchimneys.init.Groups;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config
extends ModConfig {
    public Config(String modId, FMLPreInitializationEvent event) {
        super(modId, event);
    }

    public void init() {
        String category = Smoke.class.getSimpleName();
        Smoke.coloringFactor = this.getFloat(category, "coloringFactor", 0.1f, ForgeBounds.FACTOR.getFloatBounds(), "Affects probability of coloring smoke by chimneys");
        Smoke.defaultColor = this.getColorARGB(category, "defaultColor", ColorARGB.DEFAULT, "Default smoke color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        Smoke.maxAmount = this.getInt(category, "maxAmount", 16, IntBounds.from((Integer)1, (Integer)100), "Maximum smoke particles amount per chimney");
        Smoke.maxIntencity = this.getInt(category, "maxIntencity", 4, IntBounds.from((Integer)0, (Integer)20), "Maximum smoke blow out distance");
        Smoke.maxScale = this.getFloat(category, "maxScale", 2.5f, FloatBounds.from((Float)Float.valueOf(1.0f), (Float)Float.valueOf(10.0f)), "Maximum smoke particles scale");
        Smoke.maxRenderDistance = this.getInt(category, "maxRenderDistance", 128, IntBounds.from((Integer)16, (Integer)256), "Maximum smoke particles render distance");
        Smoke.maxRenderedParticlesAmount = this.getInt(category, "maxRenderedParticlesAmount", 800, IntBounds.from((Integer)0, (Integer)2000), "Maximum smoke particles that can be rendered at scene.\nIf exceeded, smoke amount will be reduced proportionally for each rendered chimney");
        Smoke.canCollide = this.getBool(category, "canCollide", true, "If true, smoke particles will collide with obstacles");
        Smoke.emitWithoutChimney = this.getBool(category, "emitWithoutChimney", true, "If true, all emitters will produce smoke even without connected chimneys");
        Smoke.translucentTexture = this.getBool(category, "translucentTexture", false, "Set to True, if using translucent smoke textures");
        category = CreativeTabs.class.getSimpleName();
        Container.displayVents = this.getBool(category, "displayVents", true, "Whether to display vents or not");
        Container.displayPumps = this.getBool(category, "displayPumps", true, "Whether to display pumps or not");
        for (Groups group : Groups.values()) {
            String key = "display" + CommonString.capitalizeFirstChar((String)group.func_176610_l());
            group.display = this.getBool(category, key, group.display, "Whether to display a group of " + group.func_176610_l() + " blocks or not");
        }
        category = "Pump";
        TileEntityPump.invertedRedstoneSignal = this.getBool(category, "invertedRedstoneSignal", false, "If set to True, the redstone signal will turn the pump off instead of turning it on");
        TileEntityPump.requiresForgeEnergy = this.getBool(category, "requiresForgeEnergy", false, "Whether the pump requires Forge Energy to operate or not");
        TileEntityPump.energyCapacity = this.getInt(category, "energyCapacity", 10000, IntBounds.from((Integer)1, (Integer)100000), "Maximum amount of energy the pump can hold");
        TileEntityPump.energyUse = this.getInt(category, "energyUse", 50, IntBounds.from((Integer)1, (Integer)1000), "Amount of energy the pump will use per second");
    }

    public static class Factory
    extends ModConfigGui.Factory {
        public GuiScreen createConfigGui(GuiScreen parent) {
            return new ModConfigGui((ForgeMod)Main.instance, parent);
        }
    }
}

