/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.oiisa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.doubledoordev.oiisa.ModConfig;
import net.dries007.tfc.api.capability.heat.CapabilityItemHeat;
import net.dries007.tfc.api.capability.heat.IItemHeat;
import net.dries007.tfc.api.capability.size.CapabilityItemSize;
import net.dries007.tfc.objects.items.ItemsTFC;
import net.dries007.tfc.util.Helpers;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="oversizediteminstoragearea", name="OversizedItemInStorageArea", version="2.2.0", acceptedMinecraftVersions="[1.12.2]")
public class OversizedItemInStorageArea {
    public static final String MOD_ID = "oversizediteminstoragearea";
    public static final String MOD_NAME = "OversizedItemInStorageArea";
    public static final String VERSION = "2.2.0";
    private static final Pattern splitter = Pattern.compile("\\b([A-Za-z0-9:._\\s]+)");
    DamageSource playerIncinerator = new DamageSource("oiisaincinerator").func_76348_h().func_151518_m();
    Map<String, Integer> weightMap = new HashMap<String, Integer>();
    Map<String, Integer> containerSizeOverideMap = new HashMap<String, Integer>();
    @Mod.Instance(value="oversizediteminstoragearea")
    public static OversizedItemInStorageArea INSTANCE;
    static Logger log;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        log = event.getModLog();
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.splitConfig();
    }

    public void splitShit(String[] configInput, Map<String, Integer> outputSave) {
        ArrayList<String> array = new ArrayList<String>();
        if (configInput.length > 0) {
            for (String configEntry : configInput) {
                Matcher matcher = splitter.matcher(configEntry);
                while (matcher.find()) {
                    array.add(matcher.group().trim());
                }
                if (array.isEmpty()) continue;
                String key = (String)array.get(0);
                array.remove(0);
                outputSave.put(key, Integer.valueOf((String)array.get(0)));
                array.clear();
            }
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            this.incineratePlayer(event.player);
        }
    }

    @SubscribeEvent
    public void onInventoryClose(PlayerContainerEvent.Close event) {
        block6: {
            ArrayList<Slot> overWeightItems;
            BlockPos tracedPos;
            World world;
            EntityPlayer player;
            block7: {
                Container container = event.getContainer();
                player = event.getEntityPlayer();
                world = player.func_130014_f_();
                String containerName = container.getClass().getName();
                tracedPos = this.getTracedPos(Helpers.rayTrace((Entity)player, (double)player.func_110148_a(EntityPlayer.REACH_DISTANCE).func_111126_e(), (float)1.0f));
                ArrayList<String> slotClassNameList = new ArrayList<String>(Arrays.asList(ModConfig.slotClassNames));
                ArrayList<String> containerClassNameList = new ArrayList<String>(Arrays.asList(ModConfig.sizeLimitOptions.sizeContainers));
                ArrayList<String> blockedItemNameList = new ArrayList<String>(Arrays.asList(ModConfig.ignoredItems));
                ArrayList<Slot> slotsToEffect = new ArrayList<Slot>();
                int maxSize = ModConfig.sizeLimitOptions.maxSize;
                this.cleanSlotList(container, slotClassNameList, slotsToEffect, containerName, player);
                this.checkItemHeat(tracedPos, containerName, world, slotsToEffect, player, blockedItemNameList);
                if (ModConfig.sizeLimitOptions.sizeWhitelist.booleanValue()) {
                    if (containerClassNameList.contains(containerName)) {
                        this.doSizeCheck(player, world, containerName, tracedPos, blockedItemNameList, slotsToEffect, maxSize);
                    }
                } else if (!containerClassNameList.contains(containerName)) {
                    this.doSizeCheck(player, world, containerName, tracedPos, blockedItemNameList, slotsToEffect, maxSize);
                }
                if (!OversizedItemInStorageArea.INSTANCE.weightMap.containsKey(containerName)) break block6;
                overWeightItems = this.checkWeight(slotsToEffect, containerName, blockedItemNameList);
                if (!ModConfig.weightLimitOptions.weightYeetItAll.booleanValue()) break block7;
                if (overWeightItems.isEmpty()) break block6;
                this.yeetAll(slotsToEffect, world, tracedPos);
                if (!ModConfig.weightLimitOptions.weightNotifyPlayer.booleanValue()) break block6;
                player.func_146105_b((ITextComponent)new TextComponentString(ModConfig.weightLimitOptions.weightEjectMessage), ModConfig.weightLimitOptions.weightActionBarMessage.booleanValue());
                break block6;
            }
            if (!overWeightItems.isEmpty()) {
                for (Slot yeetThisSlot : overWeightItems) {
                    this.yeetItem(world, tracedPos, yeetThisSlot);
                    if (!ModConfig.weightLimitOptions.weightNotifyPlayer.booleanValue()) continue;
                    player.func_146105_b((ITextComponent)new TextComponentString(ModConfig.weightLimitOptions.weightEjectMessage), ModConfig.weightLimitOptions.weightActionBarMessage.booleanValue());
                }
            }
        }
    }

    void splitConfig() {
        this.splitShit(ModConfig.weightLimitOptions.weightInventoryArray, this.weightMap);
        this.splitShit(ModConfig.sizeLimitOptions.sizeInventoryArray, this.containerSizeOverideMap);
    }

    private void doSizeCheck(EntityPlayer player, World world, String containerName, BlockPos tracedPos, ArrayList<String> blockedItemNameList, ArrayList<Slot> slotsToEffect, int maxSize) {
        if (OversizedItemInStorageArea.INSTANCE.containerSizeOverideMap.containsKey(containerName)) {
            maxSize = OversizedItemInStorageArea.INSTANCE.containerSizeOverideMap.get(containerName);
        }
        this.checkSize(slotsToEffect, tracedPos, world, player, maxSize, blockedItemNameList);
    }

    private void checkSize(ArrayList<Slot> slotsToEffect, BlockPos tracedPos, World world, EntityPlayer player, int maxSize, ArrayList<String> blockedItemNameList) {
        for (Slot slot : slotsToEffect) {
            ItemStack stackToActOn;
            int size;
            if (!slot.func_75216_d() || blockedItemNameList.contains(slot.func_75211_c().func_77973_b().getRegistryName().toString()) || (size = CapabilityItemSize.getIItemSize((ItemStack)(stackToActOn = slot.func_75211_c())).getSize(stackToActOn).ordinal()) < maxSize) continue;
            this.doYeet(tracedPos, world, slotsToEffect, slot, ModConfig.sizeLimitOptions.sizeYeetItAll, player);
            if (!ModConfig.sizeLimitOptions.sizeNotifyPlayer.booleanValue()) continue;
            player.func_146105_b((ITextComponent)new TextComponentString(ModConfig.sizeLimitOptions.sizeEjectMessage), ModConfig.sizeLimitOptions.sizeActionBarMessage.booleanValue());
        }
    }

    private ArrayList<Slot> checkWeight(ArrayList<Slot> slotsToEffect, String containerName, ArrayList<String> blockedItemNameList) {
        int currentWeight = 0;
        int maxWeight = OversizedItemInStorageArea.INSTANCE.weightMap.get(containerName);
        ArrayList<Slot> toYeet = new ArrayList<Slot>();
        for (Slot slot : slotsToEffect) {
            if (!slot.func_75216_d() || blockedItemNameList.contains(slot.func_75211_c().func_77973_b().getRegistryName().toString())) continue;
            ItemStack itemStack = slot.func_75211_c();
            if (currentWeight < maxWeight) {
                switch (CapabilityItemSize.getIItemSize((ItemStack)slot.func_75211_c()).getWeight(itemStack).ordinal()) {
                    case 0: {
                        currentWeight = ModConfig.weightLimitOptions.veryLightItemWeight * itemStack.func_190916_E() + currentWeight;
                        break;
                    }
                    case 1: {
                        currentWeight = ModConfig.weightLimitOptions.lightItemWeight * itemStack.func_190916_E() + currentWeight;
                        break;
                    }
                    case 2: {
                        currentWeight = ModConfig.weightLimitOptions.mediumItemWeight * itemStack.func_190916_E() + currentWeight;
                        break;
                    }
                    case 3: {
                        currentWeight = ModConfig.weightLimitOptions.heavyItemWeight * itemStack.func_190916_E() + currentWeight;
                        break;
                    }
                    case 4: {
                        currentWeight = ModConfig.weightLimitOptions.veryHeavyItemWeight * itemStack.func_190916_E() + currentWeight;
                    }
                }
                continue;
            }
            toYeet.add(slot);
        }
        if (ModConfig.debugOptions.debug.booleanValue() && ModConfig.debugOptions.weightDebug.booleanValue()) {
            log.info("Total Weight of Container: " + currentWeight + " Maximum weight allowed: " + maxWeight);
        }
        return toYeet;
    }

    private void cleanSlotList(Container container, ArrayList<String> slotClassNameList, ArrayList<Slot> slotsToEffect, String containerName, EntityPlayer player) {
        if (slotClassNameList.remove("net.minecraft.inventory.InventoryBasic")) {
            log.warn("Ignoring basic slot! DON'T PUT \"net.minecraft.inventory.InventoryBasic\" IN YOUR CONFIG, LIKE THE CONFIG SAYS! THIS IS NOT A BUG!");
        }
        if (ModConfig.debugOptions.debug.booleanValue()) {
            log.info(containerName);
        }
        for (Slot slot : container.field_75151_b) {
            if (ModConfig.debugOptions.debug.booleanValue() && ModConfig.debugOptions.slotDebug.booleanValue()) {
                log.info(slot.field_75224_c.getClass());
            }
            if (slotClassNameList.contains(slot.field_75224_c.getClass().getName()) || !slot.func_82869_a(player)) continue;
            slotsToEffect.add(slot);
        }
    }

    private void yeetItem(World world, BlockPos tracedPos, Slot yeetslot) {
        this.spawnYeetItem(world, tracedPos, yeetslot.func_75211_c());
        yeetslot.func_75211_c().func_190920_e(0);
        yeetslot.field_75224_c.func_70296_d();
    }

    private void yeetAll(ArrayList<Slot> slotsToEffect, World world, BlockPos tracedPos) {
        for (Slot slotToYeet : slotsToEffect) {
            if (!slotToYeet.func_75216_d()) continue;
            this.yeetItem(world, tracedPos, slotToYeet);
        }
    }

    private void doYeet(BlockPos tracedPos, World world, ArrayList<Slot> slotsToEffect, Slot yeetslot, Boolean selectiveYeet, EntityPlayer player) {
        if (tracedPos != null && world.func_175625_s(tracedPos) != null) {
            if (selectiveYeet.booleanValue()) {
                this.yeetItem(world, tracedPos, yeetslot);
            } else {
                this.yeetAll(slotsToEffect, world, tracedPos);
            }
        } else if (selectiveYeet.booleanValue()) {
            this.yeetItem(world, player.func_180425_c(), yeetslot);
        } else {
            this.yeetAll(slotsToEffect, world, player.func_180425_c());
        }
    }

    private BlockPos getTracedPos(RayTraceResult rayTrace) {
        if (rayTrace != null && rayTrace.field_72313_a != RayTraceResult.Type.MISS) {
            return rayTrace.func_178782_a();
        }
        return null;
    }

    private void checkItemHeat(BlockPos tracedPos, String containerName, World world, ArrayList<Slot> slotsToEffect, EntityPlayer player, ArrayList<String> blockedItemNameList) {
        ArrayList<String> disabledInvs = new ArrayList<String>(Arrays.asList(ModConfig.overheatOptions.disabledInventories));
        if (ModConfig.overheatOptions.heatStartsFires.booleanValue() && !disabledInvs.contains(containerName)) {
            for (Slot slot : slotsToEffect) {
                IBlockState target;
                if (!slot.func_75211_c().hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null) || blockedItemNameList.contains(slot.func_75211_c().func_77973_b().getRegistryName().toString())) continue;
                IItemHeat heatCapability = (IItemHeat)slot.func_75211_c().getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null);
                if (tracedPos == null || world.func_175625_s(tracedPos) == null || heatCapability == null || !(heatCapability.getTemperature() >= (float)ModConfig.overheatOptions.heatToStartFire)) continue;
                if (ModConfig.debugOptions.debug.booleanValue() && ModConfig.debugOptions.heatDebug.booleanValue()) {
                    log.info("Current Item Temperature: " + heatCapability.getTemperature() + " Maximum Temperature allowed: " + ModConfig.overheatOptions.heatToStartFire);
                }
                if ((target = world.func_180495_p(tracedPos)).func_185904_a().func_76217_h()) {
                    world.func_175656_a(tracedPos, Blocks.field_150480_ab.func_176223_P());
                    if (!ModConfig.overheatOptions.heatNotifyPlayer.booleanValue()) continue;
                    player.func_146105_b((ITextComponent)new TextComponentString(ModConfig.overheatOptions.heatMessage), ModConfig.overheatOptions.heatActionBarMessage.booleanValue());
                    continue;
                }
                if (!ModConfig.debugOptions.debug.booleanValue() || !ModConfig.debugOptions.heatDebug.booleanValue()) continue;
                log.info("Fire was aborted as this block can't burn.");
            }
        }
    }

    private void incineratePlayer(EntityPlayer player) {
        if (!player.func_184812_l_() && !player.func_175149_v()) {
            NonNullList playerMainInv = player.field_71071_by.field_70462_a;
            NonNullList playerArmorInv = player.field_71071_by.field_70460_b;
            NonNullList playerOffHandInv = player.field_71071_by.field_184439_c;
            World world = player.func_130014_f_();
            BlockPos playerPos = player.func_180425_c();
            String playerDisplayName = player.func_145748_c_().func_150254_d();
            ArrayList<ItemStack> ashToSpawn = new ArrayList<ItemStack>();
            for (ItemStack item : playerArmorInv) {
                IItemHeat heatCapability;
                if (!item.hasCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null) || (heatCapability = (IItemHeat)item.getCapability(CapabilityItemHeat.ITEM_HEAT_CAPABILITY, null)) == null) continue;
                float itemTemp = heatCapability.getTemperature();
                if (itemTemp >= (float)ModConfig.overheatOptions.heatToIncineratePlayer) {
                    if (ModConfig.overheatOptions.incinerateHeldBurnableItems) {
                        ItemStack insultingAsh;
                        for (ItemStack stack : playerMainInv) {
                            if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) continue;
                            if (ModConfig.overheatOptions.incinerateitemstoash) {
                                insultingAsh = new ItemStack(ItemsTFC.WOOD_ASH, stack.func_190916_E());
                                insultingAsh.func_151001_c("\u00a7r\u00a78" + stack.func_82833_r() + " Ash");
                                ashToSpawn.add(insultingAsh);
                            }
                            stack.func_190920_e(0);
                        }
                        for (ItemStack stack : playerOffHandInv) {
                            if (TileEntityFurnace.func_145952_a((ItemStack)stack) <= 0) continue;
                            if (ModConfig.overheatOptions.incinerateitemstoash) {
                                insultingAsh = new ItemStack(ItemsTFC.WOOD_ASH, stack.func_190916_E());
                                insultingAsh.func_151001_c("\u00a7r\u00a78" + stack.func_82833_r() + " Ash");
                                ashToSpawn.add(insultingAsh);
                            }
                            stack.func_190920_e(0);
                        }
                    }
                    if (ModConfig.overheatOptions.incineratedPlayersStartFires && world.func_180495_p(playerPos).func_177230_c().func_176200_f((IBlockAccess)world, playerPos)) {
                        world.func_180501_a(playerPos, Blocks.field_150480_ab.func_176223_P(), 11);
                    }
                    if (!player.field_70170_p.field_72995_K) {
                        player.func_70097_a(this.playerIncinerator, 2.1474836E9f);
                    }
                    NBTTagCompound insultingAshNBT = new NBTTagCompound();
                    NBTTagString insultingAshLore = new NBTTagString("All that remains of " + playerDisplayName + "\u00a75\u00a7o... So hot they turned to nothing but ash!");
                    NBTTagList insultingAshList = new NBTTagList();
                    insultingAshList.func_74742_a((NBTBase)insultingAshLore);
                    insultingAshNBT.func_74782_a("display", (NBTBase)new NBTTagCompound());
                    insultingAshNBT.func_74775_l("display").func_74782_a("Name", (NBTBase)new NBTTagString("\u00a78Ash of " + playerDisplayName));
                    insultingAshNBT.func_74775_l("display").func_74782_a("Lore", (NBTBase)insultingAshList);
                    ItemStack insultingAsh = new ItemStack(ItemsTFC.WOOD_ASH, 1);
                    insultingAsh.func_77982_d(insultingAshNBT);
                    EntityItem insultingAshEntity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, insultingAsh);
                    insultingAshEntity.func_174869_p();
                    insultingAshEntity.func_184224_h(true);
                    if (player.field_70170_p.field_72995_K) continue;
                    if (ModConfig.overheatOptions.incinerateitemstoash) {
                        for (ItemStack ashStack : ashToSpawn) {
                            EntityItem ashEntity = new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, ashStack);
                            ashEntity.func_184224_h(true);
                            world.func_72838_d((Entity)ashEntity);
                        }
                    }
                    world.func_72838_d((Entity)insultingAshEntity);
                    continue;
                }
                if (!(itemTemp >= (float)ModConfig.overheatOptions.heatToCombustPlayer)) continue;
                player.func_70015_d((int)(heatCapability.getTemperature() - (float)ModConfig.overheatOptions.heatToIncineratePlayer));
            }
        }
    }

    private void spawnYeetItem(World world, BlockPos pos, ItemStack item) {
        float f = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f1 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        float f2 = world.field_73012_v.nextFloat() * 0.8f + 0.1f;
        EntityItem entityitem = new EntityItem(world, (double)pos.func_177958_n() + (double)f, (double)pos.func_177956_o() + (double)f1, (double)pos.func_177952_p() + (double)f2, item.func_77979_a(world.field_73012_v.nextInt(21) + 10));
        entityitem.func_174867_a(30);
        entityitem.field_70159_w = world.field_73012_v.nextGaussian() * 0.07;
        entityitem.field_70181_x = world.field_73012_v.nextGaussian() * 0.07 + (double)0.2f;
        entityitem.field_70179_y = world.field_73012_v.nextGaussian() * 0.07;
        world.func_72838_d((Entity)entityitem);
    }
}

