/*
 * Decompiled with CFR 0.152.
 */
package net.doubledoordev.oiisa;

import net.doubledoordev.oiisa.OversizedItemInStorageArea;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="oversizediteminstoragearea", category="All")
@Mod.EventBusSubscriber(modid="oversizediteminstoragearea")
@Config.LangKey(value="oiisa.config.title")
public class ModConfig {
    @Config.Name(value="Debug Options")
    @Config.Comment(value={"Debug options."})
    public static final DebugOptions debugOptions = new DebugOptions();
    @Config.Name(value="Size Options")
    @Config.Comment(value={"Size restrictions and settings for inventories/slots."})
    public static final SizeLimitOptions sizeLimitOptions = new SizeLimitOptions();
    @Config.Name(value="Weight Options")
    @Config.Comment(value={"Weight restrictions and settings for inventories/slots."})
    public static final WeightLimitOptions weightLimitOptions = new WeightLimitOptions();
    @Config.Name(value="Overheat Options")
    @Config.Comment(value={"Overheat settings for inventories"})
    public static final OverheatOptions overheatOptions = new OverheatOptions();
    @Config.LangKey(value="oiisa.config.blocked.slots")
    @Config.Comment(value={"DO NOT ENTER InventoryBasic SLOTS HERE! Full Class path names of slots that are excluded from ALL checks. TURN ON DEBUG TO GET THESE NAMES"})
    public static String[] slotClassNames = new String[3];
    @Config.LangKey(value="oiisa.config.blocked.items")
    @Config.Comment(value={"Items that are excluded from ALL checks. F3+H to get names."})
    public static String[] ignoredItems;

    static {
        ModConfig.slotClassNames[0] = "net.minecraft.entity.player.InventoryPlayer";
        ModConfig.slotClassNames[1] = "net.minecraft.inventory.InventoryCrafting";
        ModConfig.slotClassNames[2] = "net.minecraft.inventory.InventoryCraftResult";
        ignoredItems = new String[1];
        ModConfig.ignoredItems[0] = "minecraft:dirt";
    }

    @Mod.EventBusSubscriber
    public static class SyncConfig {
        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("oversizediteminstoragearea")) {
                ConfigManager.sync((String)"oversizediteminstoragearea", (Config.Type)Config.Type.INSTANCE);
                OversizedItemInStorageArea.INSTANCE.splitConfig();
            }
        }
    }

    public static class OverheatOptions {
        @Config.LangKey(value="oiisa.config.heat.makefire")
        @Config.Comment(value={"Blocks that will burn up from a fire will be consumed by fire if an overheated item is placed inside.", "True = Fire. False = No Fire."})
        public Boolean heatStartsFires = true;
        @Config.LangKey(value="oiisa.config.heat.message")
        @Config.Comment(value={"The message displayed in-game when items are too hot for the inventory."})
        public String heatMessage = "That's Hot!";
        @Config.LangKey(value="oiisa.config.heat.message.location")
        @Config.Comment(value={"Where the eject message is sent.", "True = Action bar message. False = Chat Message."})
        public Boolean heatActionBarMessage = true;
        @Config.LangKey(value="oiisa.config.heat.message.send")
        @Config.Comment(value={"If players should be notified about issues.", "True = Send players a message. False = no message."})
        public Boolean heatNotifyPlayer = true;
        @Config.LangKey(value="oiisa.config.heat.temp")
        @Config.Comment(value={"Temperature that flammable inventories will combust."})
        @Config.RangeInt(min=0, max=0x7FFFFFFF)
        public int heatToStartFire = 600;
        @Config.LangKey(value="oiisa.config.heat.disabledinventory")
        @Config.Comment(value={"Full Class path names of inventories that are immune to burning. TURN ON DEBUG TO GET THE NAMES"})
        public String[] disabledInventories = new String[2];
        @Config.LangKey(value="oiisa.config.heat.incinerateplayer")
        @Config.Comment(value={"Temperature that players will instantly die with equipped hot armor equipped."})
        @Config.RangeInt(min=0, max=0x7FFFFFFF)
        public int heatToIncineratePlayer = 150;
        @Config.LangKey(value="oiisa.config.heat.burnplayer")
        @Config.Comment(value={"Temperature that players will instantly combust with hot armor equipped."})
        @Config.RangeInt(min=0, max=0x7FFFFFFF)
        public int heatToCombustPlayer = 70;
        @Config.LangKey(value="oiisa.config.heat.incineratedestroysitems")
        @Config.Comment(value={"Does a player incinerating there self destroy burnable items they have in there inventory?", "You can add custom options by giving items fuel time via other mods. Anything greater than 0 will combust."})
        public boolean incinerateHeldBurnableItems = true;
        @Config.LangKey(value="oiisa.config.heat.incineratedplayerstartsfire")
        @Config.Comment(value={"Does a player dying from incinerating there self start a fire where they stand?"})
        public boolean incineratedPlayersStartFires = true;
        @Config.LangKey(value="oiisa.config.heat.incinerateitemstoash")
        @Config.Comment(value={"Should burnt items be converted to ash at a 1 to 1 ratio?"})
        public boolean incinerateitemstoash = true;

        public OverheatOptions() {
            this.disabledInventories[0] = "net.dries007.tfc.objects.container.ContainerBarrel";
            this.disabledInventories[1] = "net.dries007.tfc.objects.container.ContainerFirePit";
        }
    }

    public static class WeightLimitOptions {
        @Config.LangKey(value="oiisa.config.weight.message.eject")
        @Config.Comment(value={"The message displayed in-game when items are ejected from the inventory."})
        public String weightEjectMessage = "This trunk could not handle your junk!";
        @Config.LangKey(value="oiisa.config.weight.message.location")
        @Config.Comment(value={"Where the eject message is sent.", "True = Action bar message. False = Chat Message."})
        public Boolean weightActionBarMessage = true;
        @Config.LangKey(value="oiisa.config.weight.message.send")
        @Config.Comment(value={"If players should be notified about issues.", "True = Send players a message. False = no message."})
        public Boolean weightNotifyPlayer = true;
        @Config.LangKey(value="oiisa.config.weight.yeetitall")
        @Config.Comment(value={"Should everything be tossed everywhere if a inventory is found to be over weight?"})
        public Boolean weightYeetItAll = true;
        @Config.LangKey(value="oiisa.config.weight.very_light.value")
        @Config.Comment(value={"How much a Very Light item weighs. THIS IS PER ITEM, NOT PER STACK!"})
        public int veryLightItemWeight = 1;
        @Config.LangKey(value="oiisa.config.weight.light.value")
        @Config.Comment(value={"How much a Light item weighs. THIS IS PER ITEM, NOT PER STACK!"})
        public int lightItemWeight = 3;
        @Config.LangKey(value="oiisa.config.weight.medium.value")
        @Config.Comment(value={"How much a Medium item weighs. THIS IS PER ITEM, NOT PER STACK!"})
        public int mediumItemWeight = 5;
        @Config.LangKey(value="oiisa.config.weight.heavy.value")
        @Config.Comment(value={"How much a Heavy item weighs. THIS IS PER ITEM, NOT PER STACK!"})
        public int heavyItemWeight = 10;
        @Config.LangKey(value="oiisa.config.weight.very_heavy.value")
        @Config.Comment(value={"How much a Very Heavy item weighs. THIS IS PER ITEM, NOT PER STACK!"})
        public int veryHeavyItemWeight = 15;
        @Config.LangKey(value="oiisa.config.weight.inventoryarray")
        @Config.Comment(value={"Full Class path names of inventories that are checked for weight limits. TURN ON DEBUG TO GET THE NAMES", "Number = Max Weight for Inventory.", "Example: net.dries007.tfc.objects.container.ContainerLogPile, 20"})
        public String[] weightInventoryArray = new String[1];

        public WeightLimitOptions() {
            this.weightInventoryArray[0] = "net.dries007.tfc.objects.container.ContainerChestTFC, 2000";
        }
    }

    public static class SizeLimitOptions {
        @Config.LangKey(value="oiisa.config.size.message.eject")
        @Config.Comment(value={"The message displayed in-game when items are ejected from the inventory."})
        public String sizeEjectMessage = "This trunk could not handle your junk!";
        @Config.LangKey(value="oiisa.config.size.message.location")
        @Config.Comment(value={"Where the eject message is sent.", "True = Action bar message. False = Chat Message."})
        public Boolean sizeActionBarMessage = true;
        @Config.LangKey(value="oiisa.config.size.message.send")
        @Config.Comment(value={"If players should be notified about issues.", "True = Send players a message. False = No message."})
        public Boolean sizeNotifyPlayer = true;
        @Config.LangKey(value="oiisa.config.size.yeetitall")
        @Config.Comment(value={"Should everything be tossed everywhere if a single item is found to be over sized?"})
        public Boolean sizeYeetItAll = true;
        @Config.LangKey(value="oiisa.config.size.whitelist")
        @Config.Comment(value={"Changes the default checks from whitelist to blacklist. ", "True = sizeContainers inventory are checked, False = sizeContainers inventory are NOT checked."})
        public Boolean sizeWhitelist = false;
        @Config.LangKey(value="oiisa.config.size.max")
        @Config.Comment(value={"This size and over are oversized and get ejected.", "Use sizeInvntoryMap for fine control per inventory.", "0 = Tiny, 1 = Very Small, 2 = Small, 3 = Normal, 4 = Large 5 = Very Large, 6 = Huge"})
        @Config.RangeInt(min=0, max=6)
        public int maxSize = 4;
        @Config.LangKey(value="oiisa.config.size.inventories")
        @Config.Comment(value={"Full Class path names of inventories that are ignored/checked (depends on sizeBlacklist) for oversize items. TURN ON DEBUG TO GET THESE NAMES"})
        public String[] sizeContainers = new String[8];
        @Config.LangKey(value="oiisa.config.size.inventoryarray")
        @Config.Comment(value={"Full Class path names of inventories that are checked for size limits. TURN ON DEBUG TO GET THE NAMES", "Size to start kicking items out of an inventory at. 0 = Tiny, 1 = Very Small, 2 = Small, 3 = Normal, 4 = Large 5 = Very Large, 6 = Huge", "Ignored inventories WILL NOT get checked! Adding them here DOES NOT MAKE THEM BE CHECKED!"})
        public String[] sizeInventoryArray;

        public SizeLimitOptions() {
            this.sizeContainers[0] = "net.dries007.tfc.objects.container.ContainerAnvilTFC";
            this.sizeContainers[1] = "net.dries007.tfc.objects.container.ContainerBarrel";
            this.sizeContainers[2] = "net.dries007.tfc.objects.container.ContainerLogPile";
            this.sizeContainers[3] = "net.dries007.tfc.objects.container.ContainerQuern";
            this.sizeContainers[4] = "net.dries007.tfc.objects.container.ContainerFirePit";
            this.sizeContainers[5] = "net.dries007.tfc.objects.container.ContainerCharcoalForge";
            this.sizeContainers[6] = "net.dries007.tfc.objects.container.ContainerCrucible";
            this.sizeContainers[7] = "com.feed_the_beast.ftbutilities.command.InvSeeInventory";
            this.sizeInventoryArray = new String[1];
            this.sizeInventoryArray[0] = "net.dries007.tfc.objects.container.ContainerChestTFC, 3";
        }
    }

    public static class DebugOptions {
        @Config.LangKey(value="oiisa.config.debug")
        @Config.Comment(value={"Turns on/off ALL debugging."})
        public Boolean debug = false;
        @Config.LangKey(value="oiisa.config.slot.debug")
        @Config.Comment(value={"Enable/Disable the debug logging of slots. REQUIRES DEBUG TO BE ON!"})
        public Boolean slotDebug = false;
        @Config.LangKey(value="oiisa.config.size.debug")
        @Config.Comment(value={"Enable/Disable the debug logging of size related things. REQUIRES DEBUG TO BE ON!"})
        public Boolean sizeDebug = false;
        @Config.LangKey(value="oiisa.config.weight.debug")
        @Config.Comment(value={"Enable/Disable the debug logging of weight related things. REQUIRES DEBUG TO BE ON!"})
        public Boolean weightDebug = false;
        @Config.LangKey(value="oiisa.config.heat.debug")
        @Config.Comment(value={"Enable/Disable the debug logging of heat related things. REQUIRES DEBUG TO BE ON!"})
        public Boolean heatDebug = false;
    }
}

