/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import jeresources.api.IDungeonRegistry;
import jeresources.compatibility.CompatBase;
import jeresources.entry.DungeonEntry;
import jeresources.registry.DungeonRegistry;
import jeresources.util.LogHelper;
import jeresources.util.LootTableHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;

public class DungeonRegistryImpl
implements IDungeonRegistry {
    private static List<Tuple<String, String>> categoryMapping = new LinkedList<Tuple<String, String>>();
    private static Map<String, ResourceLocation> rawRegisters = new HashMap<String, ResourceLocation>();
    private static List<DungeonEntry> preppedRegisters = new LinkedList<DungeonEntry>();

    protected DungeonRegistryImpl() {
    }

    @Override
    public void registerCategory(@Nonnull String category, @Nonnull String localization) {
        categoryMapping.add((Tuple<String, String>)new Tuple((Object)category, (Object)localization));
    }

    @Override
    public void registerChest(@Nonnull String category, @Nonnull ResourceLocation tableLocation) {
        rawRegisters.put(category, tableLocation);
    }

    @Override
    public void registerChest(@Nonnull String category, @Nonnull LootTable lootTable) {
        try {
            preppedRegisters.add(new DungeonEntry(category, lootTable));
        }
        catch (Exception e) {
            LogHelper.debug("Bad dungeon chest registry for category %s", category);
        }
    }

    protected static void commit() {
        categoryMapping.forEach(t -> DungeonRegistry.addCategoryMapping((String)t.func_76341_a(), (String)t.func_76340_b()));
        preppedRegisters.forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
        World world = CompatBase.getWorld();
        LootTableManager manager = LootTableHelper.getManager(world);
        rawRegisters.entrySet().stream().map(entry -> {
            try {
                return new DungeonEntry((String)entry.getKey(), manager.func_186521_a((ResourceLocation)entry.getValue()));
            }
            catch (Exception e) {
                LogHelper.debug("Bad dungeon chest registry for category %s", entry.getKey());
                return null;
            }
        }).forEach(entry -> DungeonRegistry.getInstance().registerDungeonEntry((DungeonEntry)entry));
    }
}

