/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.recipes.recipe;

import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.ICauldronRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;

public enum FillCauldronFromFluidContainer implements ICauldronRecipe
{
    INSTANCE;


    @Override
    public boolean matches(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        if (level == InspirationsRegistry.getCauldronMax() || level > 0 && state.getFluid() == null) {
            return false;
        }
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)stack);
        if (fluidHandler == null) {
            return false;
        }
        FluidStack fluidStack = fluidHandler.drain(1000, false);
        return ICauldronRecipe.CauldronState.fluidValid(fluidStack) && (level == 0 || fluidStack.getFluid() == state.getFluid());
    }

    @Override
    public ItemStack getResult(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        IFluidHandlerItem handler = FluidUtil.getFluidHandler((ItemStack)stack.func_77946_l());
        handler.drain(1000, true);
        return handler.getContainer();
    }

    @Override
    public int getLevel(int level) {
        return InspirationsRegistry.getCauldronMax();
    }

    @Override
    public ICauldronRecipe.CauldronState getState(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        Fluid fluid = FluidUtil.getFluidHandler((ItemStack)stack).drain(1000, false).getFluid();
        if (fluid == state.getFluid()) {
            return state;
        }
        return ICauldronRecipe.CauldronState.fluid(fluid);
    }

    @Override
    public SoundEvent getSound(ItemStack stack, boolean boiling, int level, ICauldronRecipe.CauldronState state) {
        return FluidUtil.getFluidHandler((ItemStack)stack).drain(1000, false).getFluid().getFillSound();
    }

    @Override
    public ItemStack getContainer(ItemStack stack) {
        return ItemStack.field_190927_a;
    }
}

