/*
 * Decompiled with CFR 0.152.
 */
package knightminer.inspirations.building;

import com.google.common.eventbus.Subscribe;
import knightminer.inspirations.building.BuildingEvents;
import knightminer.inspirations.building.block.BlockBookshelf;
import knightminer.inspirations.building.block.BlockEnlightenedBush;
import knightminer.inspirations.building.block.BlockFlower;
import knightminer.inspirations.building.block.BlockGlassDoor;
import knightminer.inspirations.building.block.BlockGlassTrapdoor;
import knightminer.inspirations.building.block.BlockMulch;
import knightminer.inspirations.building.block.BlockPath;
import knightminer.inspirations.building.block.BlockRope;
import knightminer.inspirations.building.tileentity.TileBookshelf;
import knightminer.inspirations.building.tileentity.TileEnlightenedBush;
import knightminer.inspirations.common.CommonProxy;
import knightminer.inspirations.common.Config;
import knightminer.inspirations.common.PulseBase;
import knightminer.inspirations.common.item.ItemBlockTexture;
import knightminer.inspirations.library.InspirationsRegistry;
import knightminer.inspirations.library.recipe.cauldron.CauldronDyeRecipe;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDoor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.item.ItemMetaDynamic;
import slimeknights.mantle.pulsar.pulse.Pulse;

@Pulse(id="InspirationsBuilding", description="A collection of features to improve building")
public class InspirationsBuilding
extends PulseBase {
    public static final String pulseID = "InspirationsBuilding";
    @SidedProxy(clientSide="knightminer.inspirations.building.BuildingClientProxy", serverSide="knightminer.inspirations.common.CommonProxy")
    public static CommonProxy proxy;
    public static Block bookshelf;
    public static BlockRope rope;
    public static Block glassDoor;
    public static Block glassTrapdoor;
    public static Block mulch;
    public static BlockPath path;
    public static Block flower;
    public static BlockEnlightenedBush enlightenedBush;
    public static Item glassDoorItem;
    public static ItemMetaDynamic books;
    public static ItemStack redstoneBook;

    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        proxy.preInit();
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry r = event.getRegistry();
        if (Config.enableBookshelf) {
            bookshelf = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockBookshelf(), "bookshelf");
            InspirationsBuilding.registerTE(TileBookshelf.class, "bookshelf");
        }
        if (Config.enableRope) {
            rope = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockRope(), "rope");
        }
        if (Config.enableGlassDoor) {
            glassDoor = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockGlassDoor(), "glass_door");
            glassTrapdoor = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockGlassTrapdoor(), "glass_trapdoor");
        }
        if (Config.enableMulch) {
            mulch = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockMulch(), "mulch");
        }
        if (Config.enablePath) {
            path = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockPath(), "path");
        }
        if (Config.enableFlowers) {
            flower = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockFlower(), "flower");
        }
        if (Config.enableEnlightenedBush) {
            enlightenedBush = InspirationsBuilding.registerBlock((IForgeRegistry<Block>)r, new BlockEnlightenedBush(), "enlightened_bush");
            InspirationsBuilding.registerTE(TileEnlightenedBush.class, "enlightened_bush");
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry r = event.getRegistry();
        books = InspirationsBuilding.registerItem((IForgeRegistry<Item>)r, new ItemMetaDynamic(), "books");
        books.func_77637_a(CreativeTabs.field_78035_l);
        if (Config.enableColoredBooks) {
            for (EnumDyeColor color : EnumDyeColor.values()) {
                books.addMeta(color.func_176765_a(), color.func_176610_l());
            }
        }
        if (Config.enableRedstoneBook && InspirationsBuilding.isUtilityLoaded()) {
            redstoneBook = books.addMeta(16, "redstone");
        }
        if (bookshelf != null) {
            InspirationsBuilding.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockTexture(bookshelf), BlockBookshelf.TYPE);
        }
        if (rope != null) {
            InspirationsBuilding.registerEnumItemBlock((IForgeRegistry<Item>)r, rope);
        }
        if (mulch != null) {
            InspirationsBuilding.registerItemBlock((IForgeRegistry<Item>)r, mulch, BlockMulch.COLOR);
        }
        if (path != null) {
            InspirationsBuilding.registerEnumItemBlock((IForgeRegistry<Item>)r, path);
        }
        if (flower != null) {
            InspirationsBuilding.registerItemBlock((IForgeRegistry<Item>)r, flower, BlockFlower.TYPE);
        }
        if (enlightenedBush != null) {
            InspirationsBuilding.registerItemBlock((IForgeRegistry<Item>)r, new ItemBlockTexture((Block)enlightenedBush), BlockEnlightenedBush.LIGHTS);
        }
        if (Config.enableGlassDoor) {
            glassDoorItem = InspirationsBuilding.registerItem((IForgeRegistry<Item>)r, new ItemDoor(glassDoor){

                public int getItemBurnTime(ItemStack stack) {
                    return 0;
                }
            }, "glass_door");
            InspirationsBuilding.registerItemBlock((IForgeRegistry<Item>)r, glassTrapdoor);
        }
    }

    @Subscribe
    public void init(FMLInitializationEvent event) {
        proxy.init();
        if (Config.enableFlowers && Config.enableCauldronDyeing) {
            InspirationsRegistry.addCauldronRecipe(new CauldronDyeRecipe(new ItemStack(flower, 1, BlockFlower.FlowerType.ROSE.getMeta()), EnumDyeColor.CYAN, new ItemStack(flower, 1, BlockFlower.FlowerType.CYAN.getMeta())));
        }
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        MinecraftForge.EVENT_BUS.register(BuildingEvents.class);
    }
}

