/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.ctm.client.texture.ctx;

import java.util.EnumMap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import team.chisel.ctm.api.texture.ITextureContext;
import team.chisel.ctm.client.texture.render.TextureCTM;
import team.chisel.ctm.client.util.CTMLogic;

public class TextureContextCTM
implements ITextureContext {
    protected final TextureCTM tex;
    private EnumMap<EnumFacing, CTMLogic> ctmData = new EnumMap(EnumFacing.class);
    private long data;

    public TextureContextCTM(@Nonnull IBlockState state, IBlockAccess world, BlockPos pos, TextureCTM tex) {
        this.tex = tex;
        for (EnumFacing face : EnumFacing.field_82609_l) {
            CTMLogic ctm = this.createCTM(state);
            ctm.createSubmapIndices(world, pos, face);
            this.ctmData.put(face, ctm);
            this.data |= ctm.serialized() << face.ordinal() * 10;
        }
    }

    protected CTMLogic createCTM(@Nonnull IBlockState state) {
        CTMLogic ret = CTMLogic.getInstance().ignoreStates(this.tex.ignoreStates()).actualStates(this.tex.actualStates()).stateComparator(this.tex::connectTo);
        ret.disableObscuredFaceCheck = this.tex.connectInside();
        return ret;
    }

    public CTMLogic getCTM(EnumFacing face) {
        return this.ctmData.get(face);
    }

    @Override
    public long getCompressedData() {
        return this.data;
    }
}

