/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.network.packet;

import de.shyrik.atlasextras.features.travel.AtlasHandler;
import de.shyrik.atlasextras.network.NetworkHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class UpdateMarkerPacket
implements IMessage,
IMessageHandler<UpdateMarkerPacket, IMessage> {
    private int dimId;
    private String name;
    private BlockPos pos;
    private String modId;
    private boolean canTravelTo;
    private boolean canTravelFrom;

    public UpdateMarkerPacket() {
    }

    public UpdateMarkerPacket(int dimId, BlockPos pos, String name, boolean canTravelTo, boolean canTravelFrom, String modId) {
        this.dimId = dimId;
        this.pos = pos;
        this.name = name;
        this.modId = modId;
        this.canTravelFrom = canTravelFrom;
        this.canTravelTo = canTravelTo;
    }

    public void fromBytes(ByteBuf buf) {
        this.dimId = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.modId = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.canTravelFrom = buf.readBoolean();
        this.canTravelTo = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dimId);
        buf.writeLong(this.pos.func_177986_g());
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.modId);
        buf.writeBoolean(this.canTravelFrom);
        buf.writeBoolean(this.canTravelTo);
    }

    public IMessage onMessage(UpdateMarkerPacket message, MessageContext ctx) {
        NetworkHelper.getThreadListener(ctx).func_152344_a(() -> {
            WorldServer w = FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(message.dimId);
            AtlasHandler.addMarker((World)w, message.pos, message.name, message.canTravelTo, message.canTravelFrom, message.modId);
        });
        return null;
    }
}

