/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.network;

import de.shyrik.atlasextras.network.packet.MarkerClickPacket;
import de.shyrik.atlasextras.network.packet.TravelEffectPacket;
import de.shyrik.atlasextras.network.packet.UpdateMarkerPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkHelper {
    private static final SimpleNetworkWrapper dispatcher = NetworkRegistry.INSTANCE.newSimpleChannel("atlasextras");
    private static int packetId = 0;

    public static void registerPackets() {
        dispatcher.registerMessage(MarkerClickPacket.class, MarkerClickPacket.class, packetId++, Side.SERVER);
        dispatcher.registerMessage(TravelEffectPacket.class, TravelEffectPacket.class, packetId++, Side.CLIENT);
        dispatcher.registerMessage(UpdateMarkerPacket.class, UpdateMarkerPacket.class, packetId++, Side.SERVER);
    }

    public static IThreadListener getThreadListener(MessageContext ctx) {
        return ctx.side == Side.SERVER ? (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p : NetworkHelper.getClientThreadListener();
    }

    @SideOnly(value=Side.CLIENT)
    public static IThreadListener getClientThreadListener() {
        return Minecraft.func_71410_x();
    }

    public static EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    public static void sendToAll(IMessage message) {
        dispatcher.sendToAll(message);
    }

    public static void sendToServer(IMessage message) {
        dispatcher.sendToServer(message);
    }

    public static void sendAround(IMessage message, BlockPos pos, int dimId) {
        dispatcher.sendToAllAround(message, new NetworkRegistry.TargetPoint(dimId, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0));
    }
}

