/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.features.travel;

import de.shyrik.atlasextras.core.Configuration;
import de.shyrik.atlasextras.features.travel.MarkerMap;
import de.shyrik.atlasextras.network.NetworkHelper;
import de.shyrik.atlasextras.network.packet.TravelEffectPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class TravelHandler {
    private static Map<String, ICostHandler> handlers = new HashMap<String, ICostHandler>();

    public static void registerCostHandler(String modid, ICostHandler handler) {
        handlers.put(modid, handler);
    }

    public static void travel(World world, int markerId, String playerUUID) {
        MarkerMap map = MarkerMap.instance(world);
        EntityPlayer player = world.func_152378_a(UUID.fromString(playerUUID));
        MarkerMap.Mark mark = map.get(markerId);
        if (mark != null && mark.canTravelTo && player != null && map.hasJumpNearby(player.func_180425_c()) && (player.func_184812_l_() || TravelHandler.canTravel(mark.sourceMod, player, mark.pos))) {
            if (TravelHandler.tryTravel(world, player, mark.pos)) {
                TravelHandler.pay(mark.sourceMod, player, mark.pos);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("atlasextras.message.blocked", new Object[0]));
            }
        }
    }

    private static boolean tryTravel(World world, EntityPlayer player, BlockPos pos) {
        EnumFacing face;
        if (player.func_184207_aI()) {
            player.func_184226_ay();
        }
        if (player.func_184218_aH()) {
            player.func_184210_p();
        }
        boolean flag = false;
        BlockPos targetLoc = pos;
        if (world.func_180495_p(pos).func_177230_c() instanceof BlockHorizontal && player.func_184595_k((double)(targetLoc = pos.func_177972_a(face = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)BlockHorizontal.field_185512_D))).func_177958_n() + 0.5, (double)targetLoc.func_177956_o() + 0.5, (double)targetLoc.func_177952_p() + 0.5)) {
            NetworkHelper.sendAround(new TravelEffectPacket(player.func_180425_c()), player.func_180425_c(), player.field_71093_bK);
            player.field_70177_z = TravelHandler.getRotationYaw(face.func_176734_d());
            flag = true;
        }
        if (!flag) {
            for (EnumFacing face2 : EnumFacing.field_82609_l) {
                targetLoc = pos.func_177972_a(face2);
                if (!player.func_184595_k((double)targetLoc.func_177958_n() + 0.5, (double)targetLoc.func_177956_o() + 0.5, (double)targetLoc.func_177952_p() + 0.5)) continue;
                NetworkHelper.sendAround(new TravelEffectPacket(player.func_180425_c()), player.func_180425_c(), player.field_71093_bK);
                player.field_70177_z = TravelHandler.getRotationYaw(face2.func_176734_d());
                flag = true;
                break;
            }
        }
        if (flag) {
            NetworkHelper.sendAround(new TravelEffectPacket(targetLoc), targetLoc, player.field_71093_bK);
        }
        return flag;
    }

    public static float getRotationYaw(EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return 180.0f;
            }
            case SOUTH: {
                return 0.0f;
            }
            case WEST: {
                return 90.0f;
            }
            case EAST: {
                return -90.0f;
            }
        }
        return 0.0f;
    }

    private static void pay(String modid, EntityPlayer player, BlockPos destination) {
        if (!handlers.containsKey(modid) || Configuration.COSTPROVIDER.useOwnCostProvider) {
            handlers.get("atlasextras").pay(player, destination);
        } else {
            handlers.get(modid).pay(player, destination);
        }
    }

    private static boolean canTravel(String modid, EntityPlayer player, BlockPos destination) {
        if (!handlers.containsKey(modid) || Configuration.COSTPROVIDER.useOwnCostProvider) {
            return handlers.get("atlasextras").canTravel(player, destination);
        }
        return handlers.get(modid).canTravel(player, destination);
    }

    public static interface ICostHandler {
        public void pay(EntityPlayer var1, BlockPos var2);

        public boolean canTravel(EntityPlayer var1, BlockPos var2);
    }
}

