/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.features.travel;

import de.shyrik.atlasextras.core.Configuration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;

public class MarkerMap
extends WorldSavedData {
    private static final String DATA_ID = "atlasextras:atlasmarkermap";
    private static final String NBT_ID = "id";
    private static final String NBT_X = "x";
    private static final String NBT_Y = "y";
    private static final String NBT_Z = "z";
    private static final String NBT_TRAVELTO = "travelto";
    private static final String NBT_TRAVELFROM = "travelfrom";
    private static final String NBT_SOURCEMOD = "sourcemod";
    private Map<Integer, Mark> marks = new ConcurrentHashMap<Integer, Mark>();

    public MarkerMap() {
        super(DATA_ID);
    }

    public MarkerMap(String s) {
        super(s);
    }

    public static MarkerMap instance(@Nonnull World world) {
        MarkerMap map = (MarkerMap)world.getPerWorldStorage().func_75742_a(MarkerMap.class, DATA_ID);
        if (map == null) {
            map = new MarkerMap();
            world.getPerWorldStorage().func_75745_a(DATA_ID, (WorldSavedData)map);
        }
        return map;
    }

    public void put(int id, BlockPos pos, boolean canJumpTo, boolean canJumpFrom, String modid) {
        this.marks.put(id, new Mark(id, pos, canJumpTo, canJumpFrom, modid));
        this.func_76185_a();
    }

    public void remove(int id) {
        this.marks.remove(id);
        this.func_76185_a();
    }

    public Mark get(int id) {
        return this.marks.getOrDefault(id, null);
    }

    public Mark getFromPos(@Nonnull BlockPos pos) {
        for (Mark entry : this.marks.values()) {
            if (entry.pos.func_177986_g() != pos.func_177986_g()) continue;
            return entry;
        }
        return null;
    }

    public boolean hasOnPos(@Nonnull BlockPos pos) {
        return this.getFromPos(pos) != null;
    }

    public boolean hasJumpNearby(@Nonnull BlockPos pos) {
        for (Mark entry : this.marks.values()) {
            if (!entry.canTravelFrom || !(entry.pos.func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) <= (double)Configuration.COMPAT.distanceToMarker)) continue;
            return true;
        }
        return false;
    }

    public void func_76184_a(@Nonnull NBTTagCompound nbt) {
        NBTTagList nbtList = nbt.func_150295_c("marks", 10);
        for (int i = 0; i < nbtList.func_74745_c(); ++i) {
            NBTTagCompound tag = nbtList.func_150305_b(i);
            int id = tag.func_74762_e(NBT_ID);
            this.marks.put(id, new Mark(id, new BlockPos(tag.func_74762_e(NBT_X), tag.func_74762_e(NBT_Y), tag.func_74762_e(NBT_Z)), tag.func_74767_n(NBT_TRAVELTO), tag.func_74767_n(NBT_TRAVELFROM), tag.func_74779_i(NBT_SOURCEMOD)));
        }
    }

    @Nonnull
    public NBTTagCompound func_189551_b(@Nonnull NBTTagCompound compound) {
        NBTTagList nbtList = new NBTTagList();
        for (Mark mark : this.marks.values()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a(NBT_ID, mark.id);
            nbt.func_74768_a(NBT_X, mark.pos.func_177958_n());
            nbt.func_74768_a(NBT_Y, mark.pos.func_177956_o());
            nbt.func_74768_a(NBT_Z, mark.pos.func_177952_p());
            nbt.func_74757_a(NBT_TRAVELTO, mark.canTravelTo);
            nbt.func_74757_a(NBT_TRAVELFROM, mark.canTravelFrom);
            nbt.func_74778_a(NBT_SOURCEMOD, mark.sourceMod);
            nbtList.func_74742_a((NBTBase)nbt);
        }
        compound.func_74782_a("marks", (NBTBase)nbtList);
        return compound;
    }

    public class Mark {
        public int id;
        public BlockPos pos;
        public boolean canTravelTo;
        public boolean canTravelFrom;
        public String sourceMod;

        public Mark(int id, BlockPos pos, boolean canTravelTo, boolean canTravelFrom, String sourceMod) {
            this.id = id;
            this.pos = pos;
            this.canTravelTo = canTravelTo;
            this.canTravelFrom = canTravelFrom;
            this.sourceMod = sourceMod;
        }
    }
}

