/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.features.travel;

import de.shyrik.atlasextras.core.Configuration;
import de.shyrik.atlasextras.features.travel.TravelHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class AtlasExtrasCostHandler
implements TravelHandler.ICostHandler {
    @Override
    public void pay(EntityPlayer player, BlockPos destination) {
        double distance = player.func_180425_c().func_185332_f(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p());
        switch (Configuration.COSTPROVIDER.costUnit) {
            case HUNGER: {
                int hungerCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? 1 : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                player.func_71024_bL().func_75122_a(-1 * hungerCost, 0.0f);
                break;
            }
            case XP: {
                int xpCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? Configuration.COSTPROVIDER.xpAmount : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                player.func_71023_q(xpCost * -1);
                break;
            }
            case ITEM: {
                int itemCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? 1 : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                ItemStack goaway = Configuration.COSTPROVIDER.itemCost;
                player.field_71071_by.func_174925_a(goaway.func_77973_b(), goaway.func_77960_j(), itemCost, null);
                break;
            }
        }
    }

    @Override
    public boolean canTravel(EntityPlayer player, BlockPos destination) {
        double distance = player.func_180425_c().func_185332_f(destination.func_177958_n(), destination.func_177956_o(), destination.func_177952_p());
        String messsageKey = "atlasextras.message.toofaraway";
        if ((double)Configuration.COSTPROVIDER.maxTravelDistance <= distance) {
            switch (Configuration.COSTPROVIDER.costUnit) {
                case HUNGER: {
                    int hungerCost;
                    int n = hungerCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? 1 : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                    if ((float)player.func_71024_bL().func_75116_a() + player.func_71024_bL().func_75115_e() > (float)hungerCost) {
                        player.func_71024_bL().func_75122_a(-1 * hungerCost, 0.0f);
                        return true;
                    }
                    messsageKey = "atlasextras.message.todayumexpensive";
                    break;
                }
                case XP: {
                    int xpCost;
                    int n = xpCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? Configuration.COSTPROVIDER.xpAmount : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                    if (player.field_71067_cb > xpCost) {
                        player.func_71023_q(xpCost * -1);
                        return true;
                    }
                    messsageKey = "atlasextras.message.todayumexpensive";
                    break;
                }
                case ITEM: {
                    int itemCost = Configuration.COSTPROVIDER.blocksPerUnit == 0 ? 1 : (int)(distance / (double)Configuration.COSTPROVIDER.blocksPerUnit);
                    int playerItemCount = 0;
                    for (ItemStack now : player.field_71071_by.field_70462_a) {
                        if (!ItemStack.func_179545_c((ItemStack)now, (ItemStack)Configuration.COSTPROVIDER.itemCost)) continue;
                        playerItemCount += now.func_190916_E();
                    }
                    if (playerItemCount > itemCost) {
                        ItemStack goaway = Configuration.COSTPROVIDER.itemCost;
                        player.field_71071_by.func_174925_a(goaway.func_77973_b(), goaway.func_77960_j(), playerItemCount, null);
                        return true;
                    }
                    messsageKey = "atlasextras.message.todayumexpensive";
                    break;
                }
                case NOTHING: {
                    return true;
                }
            }
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation(messsageKey, new Object[0]));
        return false;
    }
}

