/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.features;

import de.shyrik.atlasextras.core.Configuration;
import de.shyrik.atlasextras.util.AtlasHelper;
import de.shyrik.atlasextras.util.MCDateTime;
import hunternif.mc.atlas.client.gui.GuiAtlas;
import kenkron.antiqueatlasoverlay.AAOConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class OverlayHandler {
    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onRenderGameOverlay(RenderGameOverlayEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (Configuration.HUD.toggleHUDDisplay && event.getType() == RenderGameOverlayEvent.ElementType.TEXT && mc.field_71441_e != null && !mc.field_71474_y.field_74330_P) {
            if (!AAOConfig.appearance.enabled) {
                return;
            }
            if (AtlasHelper.getPlayerAtlas((EntityPlayer)mc.field_71439_g) == null) {
                return;
            }
            boolean openAtlas = mc.field_71462_r instanceof GuiAtlas;
            float gameWidth = (float)event.getResolution().func_78327_c();
            float gameHeight = (float)event.getResolution().func_78324_d();
            BlockPos pos = mc.field_71439_g.func_180425_c();
            Configuration.InfoPosition renderPos = Configuration.HUD.displayPosition;
            float scale = Configuration.HUD.textScale.scale;
            float upscale = 1.0f / scale;
            GlStateManager.func_179094_E();
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            int row = 0;
            if (Configuration.HUD.enablePositionInfo) {
                String infoPos = "x: " + pos.func_177958_n() + " y: " + pos.func_177956_o() + " z: " + pos.func_177952_p();
                if (Configuration.HUD.nonVerbose) {
                    String sep = Configuration.HUD.nonVerboseSeparator.length() > 3 ? Configuration.HUD.nonVerboseSeparator.substring(0, 3) : Configuration.HUD.nonVerboseSeparator;
                    infoPos = pos.func_177958_n() + sep + pos.func_177956_o() + sep + pos.func_177952_p();
                }
                if (openAtlas && renderPos != Configuration.InfoPosition.MINIMAP) {
                    OverlayHandler.drawOpenAtlasInfoLine(mc.field_71466_p, (GuiAtlas)mc.field_71462_r, row++, infoPos, upscale);
                } else if (renderPos != Configuration.InfoPosition.OPENATLAS) {
                    OverlayHandler.drawMiniMapInfoLine(mc.field_71466_p, row++, gameWidth, gameHeight, infoPos, upscale);
                }
            }
            if (Configuration.HUD.enableBiomeInfo) {
                String infoBiome = mc.field_71441_e.func_180494_b(pos).func_185359_l();
                if (openAtlas && renderPos != Configuration.InfoPosition.MINIMAP) {
                    OverlayHandler.drawOpenAtlasInfoLine(mc.field_71466_p, (GuiAtlas)mc.field_71462_r, row++, infoBiome, upscale);
                } else if (renderPos != Configuration.InfoPosition.OPENATLAS) {
                    OverlayHandler.drawMiniMapInfoLine(mc.field_71466_p, row++, gameWidth, gameHeight, infoBiome, upscale);
                }
            }
            if (Configuration.HUD.enableTimeInfo) {
                MCDateTime dt = new MCDateTime(mc.field_71441_e.func_72820_D());
                String infoTime = String.format("%s - %02d:%02d", dt.getDayName(), dt.hour, dt.min);
                if (openAtlas && renderPos != Configuration.InfoPosition.MINIMAP) {
                    OverlayHandler.drawOpenAtlasInfoLine(mc.field_71466_p, (GuiAtlas)mc.field_71462_r, row, infoTime, upscale);
                } else if (renderPos != Configuration.InfoPosition.OPENATLAS) {
                    OverlayHandler.drawMiniMapInfoLine(mc.field_71466_p, row, gameWidth, gameHeight, infoTime, upscale);
                }
            }
            GlStateManager.func_179121_F();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawMiniMapInfoLine(FontRenderer fontRenderer, int row, float gameWidth, float gameHeight, String info, float scale) {
        float infoWidth = fontRenderer.func_78256_a(info);
        float atlasX = (float)AAOConfig.position.xPosition * scale;
        if (AAOConfig.position.alignRight) {
            atlasX = (gameWidth - (atlasX + (float)AAOConfig.position.width)) * scale;
        }
        float startX = atlasX + ((float)AAOConfig.position.width * scale / 2.0f - infoWidth / 2.0f);
        float atlasY = (float)(AAOConfig.position.yPosition + 2) * scale + (float)row * ((float)fontRenderer.field_78288_b + 1.0f * scale);
        if (AAOConfig.position.alignBottom) {
            atlasY = gameHeight * scale - (atlasY + (float)AAOConfig.position.height * scale);
        }
        float startY = atlasY + (float)(AAOConfig.position.alignBottom ? -6 : AAOConfig.position.height) * scale;
        fontRenderer.func_175065_a(info, startX, startY, Configuration.HUD.RGB, false);
    }

    @SideOnly(value=Side.CLIENT)
    private static void drawOpenAtlasInfoLine(FontRenderer fontRenderer, GuiAtlas gui, int row, String info, float scale) {
        float infoWidth = fontRenderer.func_78256_a(info);
        float startX = (float)gui.getGuiX() * scale + (310.0f * scale / 2.0f - infoWidth / 2.0f);
        float startY = (float)(gui.getGuiY() + 2) * scale + (float)row * ((float)fontRenderer.field_78288_b + 1.0f * scale) + 218.0f * scale;
        fontRenderer.func_175065_a(info, startX, startY, Configuration.HUD.RGB, false);
    }
}

