/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.core;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="atlasextras", category="")
public class Configuration {
    public static final HUD HUD = new HUD();
    public static final Compat COMPAT = new Compat();
    @Config.Comment(value={"Category is obsolete if fasttravel is disabled"})
    public static final CostProvider COSTPROVIDER = new CostProvider();

    public static void Save() {
        ConfigManager.sync((String)"atlasextras", (Config.Type)Config.Type.INSTANCE);
    }

    private static ItemStack parseCfgItem(String s) {
        String[] split = s.split(":");
        if (split.length < 2 || split.length > 3) {
            return ItemStack.field_190927_a;
        }
        Item tmp = Item.func_111206_d((String)new ResourceLocation(split[0], split[1]).toString());
        if (tmp == null) {
            return ItemStack.field_190927_a;
        }
        if (split.length == 2) {
            return new ItemStack(tmp);
        }
        return new ItemStack(tmp, Integer.getInteger(split[2]).intValue());
    }

    @Mod.EventBusSubscriber
    public static class EventHandler {
        @SubscribeEvent
        public static void onOnConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("atlasextras")) {
                ConfigManager.sync((String)"atlasextras", (Config.Type)Config.Type.INSTANCE);
                Configuration.HUD.RGB = Integer.parseInt(Configuration.HUD.color, 16);
                Configuration.COSTPROVIDER.itemCost = Configuration.parseCfgItem(Configuration.COSTPROVIDER.item);
            }
        }
    }

    public static enum InfoPosition {
        MINIMAP,
        OPENATLAS,
        BOTH;

    }

    public static enum TextScale {
        BIG(1.0f),
        NORMAL(0.75f),
        SMALL(0.5f);

        public final float scale;

        private TextScale(float scale) {
            this.scale = scale;
        }
    }

    public static enum CostUnit {
        HUNGER,
        XP,
        ITEM,
        NOTHING;

    }

    public static class CostProvider {
        @Config.Comment(value={"true to overwrite other mods costs (only through atlas travel ofc), false disables this whole section"})
        public boolean useOwnCostProvider = true;
        @Config.Comment(value={"Amount of blocks the player can travel (0 limetless - price is the limit)"})
        @Config.RangeInt(min=0, max=10000000)
        public int maxTravelDistance = 0;
        @Config.Comment(value={"Unit in which travel is to pay"})
        public CostUnit costUnit = CostUnit.HUNGER;
        @Config.Comment(value={"Amount of blocks the player can travel per cost Unit (0 = just 1 unit needs to be payed)"})
        @Config.RangeInt(min=0, max=10000000)
        public int blocksPerUnit = 0;
        @Config.Comment(value={"If costUnit is XP - how much xp should be drained per use"})
        @Config.RangeInt(min=0, max=10000000)
        public int xpAmount = 50;
        @Config.Comment(value={"If costUnit is ITEM - which item is needed as pay (modid:itemname:meta)"})
        public String item = "";
        @Config.Ignore
        public ItemStack itemCost = Configuration.access$000(this.item);
    }

    public static class Compat {
        @Config.Comment(value={"true to allow fast traveling by clicking on a valid marker, false otherwise"})
        public boolean enableFastTravel = true;
        @Config.Comment(value={"true to add signposts markers, false otherwise"})
        public boolean compatSignpost = true;
        @Config.Comment(value={"true to add waystones markers, false otherwise"})
        public boolean compatWaystone = true;
        @Config.Comment(value={"The maximum amount of blocks the player can be away of a sign to travel"})
        @Config.RangeInt(min=1, max=32)
        public int distanceToMarker = 5;
    }

    public static class HUD {
        @Config.Comment(value={"true if the biome info should be shown, false otherwise"})
        public boolean enableBiomeInfo = true;
        @Config.Comment(value={"true if the position info should be shown, false otherwise"})
        public boolean enablePositionInfo = true;
        @Config.Comment(value={"true if the time info should be shown, false otherwise"})
        public boolean enableTimeInfo = true;
        @Config.Comment(value={"scale of the HUD information"})
        public TextScale textScale = TextScale.NORMAL;
        @Config.Comment(value={"true removes the 'x:' from the ui and makes coords ',' separated"})
        public boolean nonVerbose = true;
        @Config.Comment(value={"the separator to use when non verbose (Max 3 characters - rest will be cutoff)"})
        public String nonVerboseSeparator = " | ";
        @Config.Comment(value={"The color to display the info in (hexadecimal)"})
        public String color = "ffffff";
        @Config.Comment(value={"where should the information be rendered"})
        public InfoPosition displayPosition = InfoPosition.BOTH;
        @Config.Comment(value={"toggles if the hud should be shown, this also has a keybind"})
        public boolean toggleHUDDisplay = true;
        @Config.Ignore
        public int RGB = Integer.parseInt(this.color, 16);
    }
}

