/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.compat;

import de.shyrik.atlasextras.features.travel.AtlasHandler;
import de.shyrik.atlasextras.features.travel.TravelHandler;
import de.shyrik.atlasextras.network.NetworkHelper;
import de.shyrik.atlasextras.network.packet.UpdateMarkerPacket;
import net.blay09.mods.waystones.PlayerWaystoneData;
import net.blay09.mods.waystones.PlayerWaystoneHelper;
import net.blay09.mods.waystones.WaystoneConfig;
import net.blay09.mods.waystones.block.BlockWaystone;
import net.blay09.mods.waystones.util.WaystoneActivatedEvent;
import net.blay09.mods.waystones.util.WaystoneEntry;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Optional.Interface(iface="de.shyrik.atlasextras.features.travel.TravelHandler.ICostHandler", modid="waystones")
public class WaystonesHandler
implements TravelHandler.ICostHandler {
    public static final String MODID = "waystones";

    @SubscribeEvent
    @Optional.Method(modid="waystones")
    public void onWaystoneActivated(WaystoneActivatedEvent event) {
        NetworkHelper.sendToServer(new UpdateMarkerPacket(event.getDimension(), event.getPos(), event.getWaystoneName(), true, true, MODID));
    }

    @SubscribeEvent
    @Optional.Method(modid="waystones")
    public void onWaystoneBroken(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && event.getState().func_177230_c() instanceof BlockWaystone) {
            AtlasHandler.removeMarker(event.getWorld(), event.getPos(), 2);
        }
    }

    @Override
    public void pay(EntityPlayer player, BlockPos destination) {
        int dist = (int)Math.sqrt(player.func_174831_c(destination));
        int xpLevelCost = WaystoneConfig.general.blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)(dist / WaystoneConfig.general.blocksPerXPLevel), (int)0, (int)WaystoneConfig.general.maximumXpCost) : 0;
        player.func_82242_a(-xpLevelCost);
        PlayerWaystoneHelper.setLastWarpStoneUse((EntityPlayer)player, (long)System.currentTimeMillis());
    }

    @Override
    public boolean canTravel(EntityPlayer player, BlockPos destination) {
        int xpLevelCost;
        int dist = (int)Math.sqrt(player.func_174831_c(destination));
        int n = xpLevelCost = WaystoneConfig.general.blocksPerXPLevel > 0 ? MathHelper.func_76125_a((int)(dist / WaystoneConfig.general.blocksPerXPLevel), (int)0, (int)WaystoneConfig.general.maximumXpCost) : 0;
        if (!PlayerWaystoneHelper.canUseWarpStone((EntityPlayer)player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("atlasextras.message.cooldown", new Object[0]));
            return false;
        }
        if (WaystoneConfig.general.inventoryButtonXpCost && player.field_71068_ca < xpLevelCost && !PlayerWaystoneHelper.canFreeWarp((EntityPlayer)player)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("atlasextras.message.toodayumexpensive", new Object[0]));
            return false;
        }
        for (WaystoneEntry entry : PlayerWaystoneData.fromPlayer((EntityPlayer)player).getWaystones()) {
            if (entry.getPos().func_177986_g() != destination.func_177986_g()) continue;
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("atlasextras.message.waypointnotknown", new Object[0]));
        return false;
    }
}

