/*
 * Decompiled with CFR 0.152.
 */
package de.shyrik.atlasextras.compat;

import de.shyrik.atlasextras.features.travel.AtlasHandler;
import de.shyrik.atlasextras.features.travel.TravelHandler;
import gollorum.signpost.blocks.SuperPostPost;
import gollorum.signpost.event.UpdateWaystoneEvent;
import gollorum.signpost.management.PostHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Optional.Interface(iface="de.shyrik.atlasextras.features.travel.TravelHandler.ICostHandler", modid="waystones")
public class SignpostHandler
implements TravelHandler.ICostHandler {
    public static final String MODID = "signpost";

    @SubscribeEvent
    @Optional.Method(modid="signpost")
    public void onUpdateWaystoneEvent(UpdateWaystoneEvent event) {
        BlockPos pos = new BlockPos(event.x, event.y, event.z);
        switch (event.type) {
            case PLACED: 
            case NAMECHANGED: {
                AtlasHandler.addMarker(event.world, pos, event.name, true, false, MODID);
                break;
            }
            case DESTROYED: {
                AtlasHandler.removeMarker(event.world, pos);
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="signpost")
    public void onSignpostPlaced(BlockEvent.PlaceEvent event) {
        if (!event.getWorld().field_72995_K && event.getPlacedBlock().func_177230_c() instanceof SuperPostPost) {
            BlockPos pos;
            World world = event.getWorld();
            if (world.func_180495_p((pos = event.getPos()).func_177984_a()).func_177230_c() instanceof SuperPostPost) {
                AtlasHandler.removeMarker(world, pos.func_177984_a());
            }
            if (!(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof SuperPostPost)) {
                AtlasHandler.addMarker(world, pos, "Signpost", false, true, MODID);
            }
        }
    }

    @SubscribeEvent
    @Optional.Method(modid="signpost")
    public void onSignpostBroken(BlockEvent.BreakEvent event) {
        if (!event.getWorld().field_72995_K && event.getState().func_177230_c() instanceof SuperPostPost) {
            AtlasHandler.removeMarker(event.getWorld(), event.getPos());
        }
    }

    @Override
    public boolean canTravel(EntityPlayer player, BlockPos destination) {
        if (!PostHandler.canPay((EntityPlayer)player, (BlockPos)player.func_180425_c(), (BlockPos)destination)) {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("atlasextras.message.toodayumexpensive", new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    public void pay(EntityPlayer player, BlockPos destination) {
        PostHandler.doPay((EntityPlayer)player, (BlockPos)player.func_180425_c(), (BlockPos)destination);
    }
}

