/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import logictechcorp.netherex.NetherEx;
import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.init.NetherExMobEffects;
import logictechcorp.netherex.village.PigtificateVillageData;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class WorldHandler {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                if (ConfigHandler.dimensionConfig.nether.overrideNether) {
                    NetherEx.BIOME_DATA_MANAGER.createBiomeDataConfigs(event);
                    NetherEx.BIOME_DATA_MANAGER.readBiomeDataConfigs(event);
                }
                NetherEx.PIGTIFICATE_VILLAGE_MANAGER.createPigtificateTradeConfigs(event);
                NetherEx.PIGTIFICATE_VILLAGE_MANAGER.readPigtificateTradeConfigs(event);
            }
            NetherEx.PIGTIFICATE_VILLAGE_MANAGER.loadVillageData(event);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        PigtificateVillageData data;
        World world = event.world;
        if (event.phase == TickEvent.Phase.END && !world.field_72995_K && (data = NetherEx.PIGTIFICATE_VILLAGE_MANAGER.getVillageData(world, false)) != null) {
            data.tick(world);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!world.field_72995_K) {
            NetherEx.PIGTIFICATE_VILLAGE_MANAGER.unloadVillageData(event);
            if (world.field_73011_w.getDimension() == DimensionType.OVERWORLD.func_186068_a()) {
                NetherEx.BIOME_DATA_MANAGER.cleanup(event);
                NetherEx.PIGTIFICATE_VILLAGE_MANAGER.cleanup(event);
            }
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof EntityAreaEffectCloud) {
            EntityAreaEffectCloud areaEffectCloud = (EntityAreaEffectCloud)entity;
            areaEffectCloud.field_184503_f.removeIf(effect -> effect.func_188419_a() == NetherExMobEffects.FIRE_BURNING);
        }
    }
}

