/*
 * Decompiled with CFR 0.152.
 */
package logictechcorp.netherex.handler;

import java.util.Random;
import logictechcorp.libraryex.utility.ArmorHelper;
import logictechcorp.netherex.entity.item.EntityObsidianBoat;
import logictechcorp.netherex.entity.passive.EntityPigtificate;
import logictechcorp.netherex.handler.ConfigHandler;
import logictechcorp.netherex.init.NetherExBiomes;
import logictechcorp.netherex.init.NetherExMaterials;
import logictechcorp.netherex.init.NetherExMobEffects;
import logictechcorp.netherex.mobeffect.MobEffectFrozen;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemArmor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="netherex")
public class LivingHandler {
    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityPigZombie zombiePigman;
        NBTTagCompound entityData;
        World world = event.getEntityLiving().func_130014_f_();
        BlockPos pos = new BlockPos((Entity)event.getEntityLiving());
        EntityLivingBase entity = event.getEntityLiving();
        Random random = world.field_73012_v;
        Biome biome = world.func_180494_b(pos);
        if (MobEffectFrozen.canFreeze(entity) && !entity.func_70644_a(NetherExMobEffects.FROZEN) && biome == NetherExBiomes.ARCTIC_ABYSS && random.nextInt(ConfigHandler.biomeConfig.arcticAbyss.mobFreezeRarity) == 0) {
            if (entity instanceof EntityPlayer) {
                entity.func_70690_d(new PotionEffect(NetherExMobEffects.FROZEN, 100, 0));
            } else {
                entity.func_70690_d(new PotionEffect(NetherExMobEffects.FROZEN, 300, 0));
            }
        }
        if (entity instanceof EntityPigZombie && (entityData = (zombiePigman = (EntityPigZombie)entity).getEntityData()).func_74764_b("ConversionTime")) {
            int conversionTime = entityData.func_74762_e("ConversionTime");
            int conversionProgress = 1;
            if (random.nextFloat() < 0.01f) {
                int conversionBoosters = 0;
                BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                for (int x = (int)zombiePigman.field_70165_t - 4; x < (int)zombiePigman.field_70165_t + 4 && conversionBoosters < 14; ++x) {
                    for (int y = (int)zombiePigman.field_70163_u - 4; y < (int)zombiePigman.field_70163_u + 4 && conversionBoosters < 14; ++y) {
                        for (int z = (int)zombiePigman.field_70161_v - 4; z < (int)zombiePigman.field_70161_v + 4 && conversionBoosters < 14; ++z) {
                            Block block = world.func_180495_p((BlockPos)mutableBlockPos.func_181079_c(x, y, z)).func_177230_c();
                            if (block != Blocks.field_150411_aY) continue;
                            if (random.nextFloat() < 0.3f) {
                                ++conversionProgress;
                            }
                            ++conversionBoosters;
                        }
                    }
                }
            }
            if ((conversionTime -= conversionProgress) <= 0) {
                EntityPigtificate pigtificate = new EntityPigtificate(world);
                pigtificate.func_82149_j((Entity)zombiePigman);
                pigtificate.setLookingForHome();
                if (zombiePigman.func_70631_g_()) {
                    pigtificate.func_70873_a(-24000);
                }
                world.func_72900_e((Entity)zombiePigman);
                pigtificate.func_94061_f(zombiePigman.func_175446_cd());
                if (zombiePigman.func_145818_k_()) {
                    pigtificate.func_96094_a(zombiePigman.func_95999_t());
                    pigtificate.func_174805_g(zombiePigman.func_174833_aM());
                }
                world.func_72838_d((Entity)pigtificate);
                pigtificate.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 200, 0));
                world.func_180498_a(null, 1027, new BlockPos((int)zombiePigman.field_70165_t, (int)zombiePigman.field_70163_u, (int)zombiePigman.field_70161_v), 0);
            } else {
                entityData.func_74768_a("ConversionTime", conversionTime);
            }
        }
    }

    @SubscribeEvent
    public static void onSetAttackTarget(LivingSetAttackTargetEvent event) {
        EntityLivingBase attacker = (EntityLivingBase)event.getEntity();
        EntityLivingBase attackee = event.getTarget();
        if (attackee instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)attackee;
            if (attacker instanceof AbstractSkeleton && ArmorHelper.isWearingFullArmorSet((EntityPlayer)player, (ItemArmor.ArmorMaterial)NetherExMaterials.WITHER_BONE)) {
                ((AbstractSkeleton)attacker).func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttacked(LivingAttackEvent event) {
        EntityLivingBase entity = (EntityLivingBase)event.getEntity();
        DamageSource source = event.getSource();
        if (source.func_76347_k() && source.func_76346_g() == null && !entity.func_70045_F() && entity.func_184218_aH() && entity.func_184187_bx() instanceof EntityObsidianBoat) {
            event.setCanceled(true);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            if (source.func_76347_k() && ArmorHelper.isWearingFullArmorSet((EntityPlayer)player, (ItemArmor.ArmorMaterial)NetherExMaterials.ORANGE_SALAMANDER_HIDE)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHeal(LivingHealEvent event) {
        EntityPlayer player;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !(player = (EntityPlayer)entity).func_70644_a(MobEffects.field_76428_l) && !player.func_70644_a(MobEffects.field_76444_x) && player.func_70644_a(NetherExMobEffects.FROSTBITTEN)) {
            event.setCanceled(true);
        }
    }
}

