/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import org.objectweb.asm.tree.MethodInsnNode;

public class Minecraft {

    public static class AnimalFeeding
    extends ForgeClassTransformer {
        static final ClassName entityAnimal = ClassName.from((String)"net.minecraft.entity.passive.EntityAnimal");
        private final MethodSignature targetMethod = MethodSignature.of((ClassName)entityAnimal, (String)"processInteract", (String)"func_184645_a", (MethodDescriptor)MethodDescriptor.of((Types)Types.BOOLEAN).withParameters(new Classes[]{Classes.ENTITY_PLAYER, Classes.ENUM_HAND}));
        private final MethodSignature targetInstruct = MethodSignature.of((ClassName)entityAnimal, (String)"consumeItemFromStack", (String)"func_175505_a", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Classes[]{Classes.ENTITY_PLAYER, Classes.ITEM_STACK}));
        private final MethodSignature handler;

        public AnimalFeeding() {
            this.handler = this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Descriptor[]{ClassDescriptor.from((ClassName)entityAnimal), Classes.ITEM_STACK.descriptor}));
        }

        public static void handle(EntityAnimal animal, ItemStack food) {
            Main.getSources().animalFeeding.emitFrom(animal, food);
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return this.handler;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return this.targetInstruct.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return true;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().loadObjFrom(3, "stack").invokeStatic(this.getHandler()).insertBefore();
        }
    }

    public static class FurnaceSmelting
    extends ForgeClassTransformer {
        private final MethodSignature targetMethod;
        private final MethodSignature handler;

        public FurnaceSmelting() {
            this.targetMethod = MethodSignature.of((ClassName)Classes.TILE_ENTITY_FURNACE.name, (String)"smeltItem", (MethodDescriptor)MethodDescriptor.VOID);
            this.handler = this.getDefaultHandlerWith(MethodDescriptor.VOID.withParameters(new Classes[]{Classes.TILE_ENTITY, Classes.ITEM_STACK}));
        }

        public static void handle(TileEntity tile, ItemStack stack) {
            if (WorldData.FurnaceFuelBurned.generateEmissions) {
                WorldData.onFuelBurned(tile, stack);
            }
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return this.handler;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.swap().dup().loadThis().swap().invokeStatic(this.getHandler()).swap().insertBefore();
        }
    }
}

