/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class Metallurgy {

    public static class Crusher
    extends BaseTileEntity {
        @Override
        protected String getClassName() {
            return "it.hurts.metallurgy_reforged.tileentity.TileEntityCrusher";
        }
    }

    public static class Alloyer
    extends BaseTileEntity {
        @Override
        protected String getClassName() {
            return "it.hurts.metallurgy_reforged.tileentity.TileEntityAlloyer";
        }
    }

    static abstract class BaseTileEntity
    extends ForgeClassTransformer {
        private MethodSignature targetMethod = MethodSignature.I_TICKABLE_UPDATE.with(this.getClassName());

        BaseTileEntity() {
        }

        protected abstract String getClassName();

        public boolean isCompatibilityMode() {
            return true;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.pop().dup().loadThis().swap().invokeStatic(this.getHandler()).pushInt(1).insertBefore();
        }
    }
}

