/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class Mekanism {

    public static class HeatGenerator
    extends ForgeClassTransformer {
        private final String className = "mekanism/generators/common/tile/TileEntityHeatGenerator";
        private final FieldSignature inventory;
        private final MethodSignature target;

        public HeatGenerator() {
            this.inventory = FieldSignature.of((String)"mekanism/generators/common/tile/TileEntityHeatGenerator", (String)"inventory", (Descriptor)Classes.NON_NULL_LIST.descriptor);
            this.target = MethodSignature.of((String)"mekanism/generators/common/tile/TileEntityHeatGenerator", (String)"onUpdate", (MethodDescriptor)MethodDescriptor.VOID);
        }

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().loadThis().getField(this.inventory).pushInt(0).invokeVirtual(MethodSignature.NON_NULL_LIST_GET).checkCast(Classes.ITEM_STACK.name).invokeStatic(this.getHandler()).insertBefore();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }

    public static class FuelwoodHeater
    extends ForgeClassTransformer {
        private final String className = "mekanism.common.tile.TileEntityFuelwoodHeater";
        private final MethodSignature target = MethodSignature.of((String)"mekanism.common.tile.TileEntityFuelwoodHeater", (String)"onUpdate", (MethodDescriptor)MethodDescriptor.VOID);

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.ITEM_STACK_SHRINK.complyWith(node);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.loadThis().loadObjFrom(2, "preShrunk").invokeStatic(this.getHandler()).insertAfter();
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }
}

