/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ArrayDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import org.objectweb.asm.tree.MethodInsnNode;

public class ImmersiveEngineering {
    private static final String PREFIX_COMMON = "blusunrize/immersiveengineering/common/";
    private static final String PREFIX_STONE = "blusunrize/immersiveengineering/common/blocks/stone/";
    private static final String PREFIX_METAL = "blusunrize/immersiveengineering/common/blocks/metal/";

    public static class TileEntityDieselGenerator
    extends TileBase {
        private final FieldSignature tanks;

        public TileEntityDieselGenerator() {
            this.tanks = FieldSignature.of((String)this.getTargetMethod().className.normal, (String)"tanks", (Descriptor)ArrayDescriptor.of((Classes)Classes.FLUID_TANK));
        }

        @Override
        protected String getNamePrefix() {
            return ImmersiveEngineering.PREFIX_METAL;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return MethodSignature.FLUID_TANK_DRAIN.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.forceNormalNames().loadThis().getField(this.tanks).loadFromArray(0).invokeVirtual(MethodSignature.FLUID_TANK_GET_FLUID).loadThis().swap().loadIntFrom(3, "fluidConsumed").invokeStatic(this.getHandler()).insertBefore();
        }

        @Override
        protected MethodSignature getHandler() {
            return Handlers.ON_FLUID_FUEL_STACK_BURNED_BY_TILE_AMOUNT;
        }
    }

    public static class TileEntityBlastFurnace
    extends TileBase {
        private MethodSignature targetNode = MethodSignature.of((String)"blusunrize/immersiveengineering/api/crafting/BlastFurnaceRecipe", (String)"getBlastFuelTime", (MethodDescriptor)MethodDescriptor.of((Types)Types.INT).withParameters(new Classes[]{Classes.ITEM_STACK}));

        @Override
        protected String getNamePrefix() {
            return ImmersiveEngineering.PREFIX_STONE;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.forceNormalNames().loadThis().loadThis().getField(this.inventory).pushInt(1).invokeVirtual(MethodSignature.NON_NULL_LIST_GET).checkCast(Classes.ITEM_STACK.name).invokeStatic(this.getHandler()).insertAfter();
        }
    }

    public static class TileEntityCokeOven
    extends TileBase {
        private final MethodSignature targetNode;

        public TileEntityCokeOven() {
            this.targetNode = MethodSignature.of((String)"blusunrize/immersiveengineering/common/util/Utils", (String)"modifyInvStackSize", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.NON_NULL_LIST.descriptor, Types.INT.descriptor, Types.INT.descriptor}));
        }

        @Override
        protected String getNamePrefix() {
            return ImmersiveEngineering.PREFIX_STONE;
        }

        public boolean isCompatibilityMode() {
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode node) {
            return this.targetNode.complyWith(node);
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.forceNormalNames().loadThis().getField(this.inventory).pushInt(0).invokeVirtual(MethodSignature.NON_NULL_LIST_GET).checkCast(Classes.ITEM_STACK.name).loadThis().swap().invokeStatic(this.getHandler()).insertBefore();
        }
    }

    private static abstract class TileBase
    extends ForgeClassTransformer {
        private final MethodSignature target = MethodSignature.I_TICKABLE_UPDATE.with(this.getNamePrefix() + ((Object)((Object)this)).getClass().getSimpleName());
        protected final FieldSignature inventory;

        private TileBase() {
            this.inventory = FieldSignature.of((String)this.getTargetMethod().className.normal, (String)"inventory", (Descriptor)Classes.NON_NULL_LIST.descriptor);
        }

        protected abstract String getNamePrefix();

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperNode) {
            return false;
        }

        protected MethodSignature getHandler() {
            return Handlers.ON_FUEL_BURNED_BY_TILE;
        }
    }
}

