/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.transformers;

import com.endertech.common.CachedValue;
import com.endertech.minecraft.forge.ForgeLocating;
import com.endertech.minecraft.forge.coremod.ForgeClassTransformer;
import com.endertech.minecraft.forge.coremod.InstructList;
import com.endertech.minecraft.forge.coremod.descriptors.ClassDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Classes;
import com.endertech.minecraft.forge.coremod.descriptors.Descriptor;
import com.endertech.minecraft.forge.coremod.descriptors.MethodDescriptor;
import com.endertech.minecraft.forge.coremod.descriptors.Types;
import com.endertech.minecraft.forge.coremod.names.ClassName;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.blocks.Sulfur;
import com.endertech.minecraft.mods.adpother.init.Pollutants;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class AcidRain {
    public static final ResourceLocation TEXTURE = ForgeLocating.environmentTexture((String)"adpother", (String)"acid_rain", (String[])new String[0]);
    static final CachedValue<Boolean> ACID_RAIN = new CachedValue((Object)false, GameTime.second().getInterval());

    static boolean isAcidRain() {
        return (Boolean)ACID_RAIN.get(player -> {
            Sulfur sulfur = (Sulfur)Pollutants.BuiltIn.SULFUR.get();
            EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
            Biome biome = player.field_70170_p.func_180494_b(player.func_180425_c());
            float threshold = sulfur.getAcidRainThresholdIn(biome);
            Percentage influence = pollution.getInfluenceOf(sulfur);
            return influence.getValue() >= threshold;
        }, (Object)Minecraft.func_71410_x().field_71439_g);
    }

    @Mod.EventBusSubscriber(value={Side.CLIENT})
    public static class Weather2 {
        static final ClassDescriptor TEXTURE_ATLAS_SPRITE = ClassDescriptor.from((String)"net.minecraft.client.renderer.texture.TextureAtlasSprite");
        static TextureAtlasSprite sprite;

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void onTextureStitch(TextureStitchEvent.Pre event) {
            sprite = event.getMap().func_174942_a(new ResourceLocation("adpother", "environment/acid_rain_weather2"));
        }

        public static class Mesh
        extends ForgeClassTransformer {
            private final MethodSignature targetMethod;
            private final MethodSignature setupMesh;

            public Mesh() {
                this.targetMethod = MethodSignature.of((String)"extendedrenderer.render.RotatingParticleManager", (String)"renderParticles", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.ENTITY.descriptor, Types.FLOAT.descriptor}));
                this.setupMesh = MethodSignature.of((String)"extendedrenderer.shader.MeshBufferManagerParticle", (String)"setupMeshForParticleIfMissing", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{TEXTURE_ATLAS_SPRITE}));
            }

            public static TextureAtlasSprite handle() {
                return sprite;
            }

            protected MethodSignature getTargetMethod() {
                return this.targetMethod;
            }

            protected MethodSignature getHandler() {
                return this.getDefaultHandlerWith(MethodDescriptor.of((Descriptor)TEXTURE_ATLAS_SPRITE));
            }

            protected boolean isProperInstruction(MethodInsnNode instruct) {
                return this.setupMesh.complyWith(instruct);
            }

            protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
                return false;
            }

            protected void injectInstructions(InstructList instructions) {
                instructions.invokeStatic(this.getHandler()).invokeStatic(this.setupMesh).insertAfter();
            }
        }

        public static class Render
        extends ForgeClassTransformer {
            private final MethodSignature targetMethod = MethodSignature.of((String)"weather2.client.SceneEnhancer", (String)"tickParticlePrecipitation", (MethodDescriptor)MethodDescriptor.VOID);
            private final MethodSignature targetInstruct;
            final int targetOccurance = 2;
            int occurance;

            public Render() {
                this.targetInstruct = MethodSignature.of((String)"extendedrenderer.particle.entity.ParticleTexExtraRender", (String)"<init>", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Descriptor[]{Classes.WORLD.descriptor, Types.DOUBLE.descriptor, Types.DOUBLE.descriptor, Types.DOUBLE.descriptor, Types.DOUBLE.descriptor, Types.DOUBLE.descriptor, Types.DOUBLE.descriptor, TEXTURE_ATLAS_SPRITE}));
                this.targetOccurance = 2;
                this.occurance = 0;
            }

            public static TextureAtlasSprite handle(TextureAtlasSprite defaultSprite) {
                return AcidRain.isAcidRain() ? sprite : defaultSprite;
            }

            protected MethodSignature getTargetMethod() {
                return this.targetMethod;
            }

            protected MethodSignature getHandler() {
                return this.getDefaultHandlerWith(MethodDescriptor.of((Descriptor)TEXTURE_ATLAS_SPRITE).withParameters(new Descriptor[]{TEXTURE_ATLAS_SPRITE}));
            }

            public boolean isCompatibilityMode() {
                return true;
            }

            protected boolean isProperInstruction(MethodInsnNode instruct) {
                if (this.targetInstruct.complyWith(instruct)) {
                    ++this.occurance;
                }
                return this.occurance == 2;
            }

            protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
                return this.occurance < 2;
            }

            protected void injectInstructions(InstructList instructions) {
                instructions.invokeStatic(this.getHandler()).insertBefore();
            }
        }
    }

    public static class DynamicSurroundings
    extends ForgeClassTransformer {
        static final String PREFIX = "org.orecruncher.dsurround.client.weather.";
        private final MethodSignature targetMethod = MethodSignature.of((String)"org.orecruncher.dsurround.client.weather.Weather$Properties", (String)"getRainTexture", (MethodDescriptor)MethodDescriptor.of((Classes)Classes.RESOURCE_LOCATION));

        public static ResourceLocation handle() {
            return AcidRain.isAcidRain() ? TEXTURE : null;
        }

        protected MethodSignature getTargetMethod() {
            return this.targetMethod;
        }

        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.of((Classes)Classes.RESOURCE_LOCATION));
        }

        protected boolean transformMethod(MethodNode method) {
            InstructList instructions = new InstructList(method, method.instructions.getFirst());
            this.injectInstructions(instructions);
            return true;
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return false;
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.invokeStatic(this.getHandler()).ifNotNullReturnObj().insertBefore();
        }
    }

    public static class Vanilla
    extends ForgeClassTransformer {
        private final MethodSignature target;

        public Vanilla() {
            this.target = MethodSignature.of((ClassName)Classes.ENTITY_RENDERER.name, (String)"renderRainSnow", (MethodDescriptor)MethodDescriptor.VOID.withParameters(new Types[]{Types.FLOAT}));
        }

        public static void handle() {
            if (AcidRain.isAcidRain()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
            }
        }

        protected MethodSignature getTargetMethod() {
            return this.target;
        }

        protected MethodSignature getHandler() {
            return this.getDefaultHandlerWith(MethodDescriptor.VOID);
        }

        protected boolean isProperInstruction(MethodInsnNode instruct) {
            return MethodSignature.TEXTURE_MANAGER_BIND_TEXTURE.complyWith(instruct);
        }

        protected boolean shouldSearchNextInstruction(MethodInsnNode lastProperInstruct) {
            return false;
        }

        protected void injectInstructions(InstructList instructions) {
            instructions.invokeStatic(this.getHandler()).insertAfter();
        }
    }
}

