/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SourceLiving<E extends EntityLivingBase>
extends SourceBase {
    public SourceLiving(UnitConfig config, UnitId id, Emissions emissions) {
        super(config, id, emissions);
    }

    public void emitFrom(E living, float factor) {
        float weight = ForgeEntity.getWeight(living, (boolean)false);
        float amount = factor * weight;
        if (CommonMath.isAlmostZero((double)amount)) {
            return;
        }
        this.emitAt(((EntityLivingBase)living).field_70170_p, this.getOutletPosition(living), amount);
    }

    public BlockPos getOutletPosition(E living) {
        EnumFacing facing = living.func_174811_aO().func_176734_d();
        World world = ((EntityLivingBase)living).field_70170_p;
        BlockPos livingPos = living.func_180425_c();
        BlockPos behindPos = livingPos.func_177972_a(facing);
        if (world.func_175667_e(behindPos) && ForgeWorld.isAirBlock((World)world, (BlockPos)behindPos)) {
            return behindPos;
        }
        return livingPos;
    }
}

