/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.coremod.hooks.BlockCaughtFireHook;
import com.endertech.minecraft.forge.coremod.hooks.BlockExplodedHook;
import com.endertech.minecraft.forge.coremod.hooks.BlockRandomTickHook;
import com.endertech.minecraft.forge.coremod.hooks.BlockStateChangeHook;
import com.endertech.minecraft.forge.coremod.hooks.FurnaceFuelBurnedHook;
import com.endertech.minecraft.forge.coremod.hooks.GetSkyColorHook;
import com.endertech.minecraft.forge.coremod.hooks.LavaTouchesWaterHook;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.Biomes;
import com.endertech.minecraft.forge.world.ChunkLoc;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.emissions.EntityEmission;
import com.endertech.minecraft.mods.adpother.emissions.IScheduledEmission;
import com.endertech.minecraft.mods.adpother.emissions.TileEmission;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.events.PlayerEvents;
import com.endertech.minecraft.mods.adpother.init.Fluids;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.sources.BreakableBlock;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.Fuel;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import com.endertech.minecraft.mods.adpother.transformers.Handlers;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class WorldData
extends WorldSavedData {
    public static IntBounds altitudeBounds = ForgeBounds.HEIGHT.getIntBounds();
    static final Map<World, WorldData> DATA_MAP = new ConcurrentHashMap<World, WorldData>();
    private static final String DATA_ID = UnitId.buildRegName((String[])new String[]{"adpother", IForgeUnit.getClassRegName(WorldData.class)});
    protected final Map<ChunkLoc, ChunkPollution> pollutionForChunk = new ConcurrentHashMap<ChunkLoc, ChunkPollution>();
    protected final Map<Entity, EntityPollution> pollutionForEntity = new ConcurrentHashMap<Entity, EntityPollution>();
    protected final Map<TileEntity, TileEmission> emissionForTile = new ConcurrentHashMap<TileEntity, TileEmission>();
    protected final Map<Entity, EntityEmission> emissionForEntity = new ConcurrentHashMap<Entity, EntityEmission>();
    private final EntityPollutant.SpawnLimiter pollutantEntityLimiter = new EntityPollutant.SpawnLimiter();

    public WorldData(String dataId) {
        super(dataId);
    }

    @Nullable
    public static Boolean onBlockRandomTick(World world, BlockPos pos) {
        Boolean result = null;
        if (ForgeWorld.isClientSide((World)world)) {
            return result;
        }
        world.field_72984_F.func_76320_a("onBlockRandomTick");
        IBlockState state = world.func_180495_p(pos);
        Torch torch = (Torch)Main.getTorches().findBy(state);
        if (torch != null) {
            torch.emitAt(world, pos);
        } else {
            Emitter emitter = (Emitter)Main.getEmitters().findBy(world, pos);
            if (emitter != null && emitter.isActive(world, pos)) {
                emitter.emitAt(world, pos);
            }
        }
        Fluids.ToxicFluids fluid = Fluids.ToxicFluids.findAt(world, pos);
        if (fluid != null) {
            fluid.affectSoilFrom(world, pos);
        }
        world.field_72984_F.func_76319_b();
        return result;
    }

    public static void onBlockBroken(World world, BlockPos pos, IBlockState state) {
        BreakableBlock breakable = (BreakableBlock)Main.getBreakables().findBy(state);
        if (breakable != null) {
            breakable.emitAt(world, pos);
        }
    }

    public static void onFuelBurned(TileEntity tile, @Nullable FluidStack stack) {
        if (stack != null) {
            WorldData.onFuelBurned(tile, stack, stack.amount);
        }
    }

    public static void onFuelBurned(TileEntity tile, @Nullable FluidStack stack, int amount) {
        if (stack != null) {
            WorldData.onFuelBurned(tile.func_145831_w(), tile.func_174877_v(), stack.getFluid(), amount);
        }
    }

    public static void onFuelBurned(Entity entity, @Nullable FluidStack stack) {
        if (stack != null) {
            WorldData.onFuelBurned(entity, stack, stack.amount);
        }
    }

    public static void onFuelBurned(Entity entity, @Nullable FluidStack stack, int amount) {
        if (stack != null) {
            WorldData.onFuelBurned(entity, stack.getFluid(), amount);
        }
    }

    public static void onFuelBurned(Entity entity, @Nullable Fluid fluid, int amount) {
        if (fluid != null) {
            WorldData.onFuelBurned(entity.func_130014_f_(), entity.func_180425_c(), fluid, amount);
        }
    }

    public static void onFuelBurned(World world, BlockPos pos, @Nullable Fluid fluid, int amount) {
        if (fluid == null) {
            return;
        }
        Block block = fluid.getBlock();
        if (block != null) {
            Item item = Item.func_150898_a((Block)block);
            if (item != Items.field_190931_a) {
                WorldData.onFuelBurned(world, pos, new ItemStack(item), amount);
            } else {
                Fuel fuel = (Fuel)Main.getFuels().findBy(block.func_176223_P());
                if (fuel != null) {
                    fuel.emitAt(world, pos, amount);
                }
            }
        }
    }

    public static void onFuelBurned(TileEntity tile, ItemStack stack) {
        WorldData.onFuelBurned(tile, stack, 1);
    }

    public static void onFuelBurned(TileEntity tile, ItemStack stack, int amount) {
        WorldData.onFuelBurned(tile.func_145831_w(), tile.func_174877_v(), stack, amount);
    }

    public static void onFuelBurned(Entity entity, ItemStack stack) {
        WorldData.onFuelBurned(entity, stack, 1);
    }

    public static void onFuelBurned(Entity entity, ItemStack stack, int amount) {
        WorldData.onFuelBurned(entity.func_130014_f_(), entity.func_180425_c(), stack, amount);
    }

    public static void onFuelBurned(World world, BlockPos pos, ItemStack stack, int amount) {
        Fuel fuel = Main.getFuels().findBy(stack);
        if (fuel != null) {
            fuel.emitAt(world, pos, amount);
        }
    }

    @Nonnull
    public static WorldData getData(World world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            if (ForgeWorld.isServerSide((World)world)) {
                MapStorage storage = world.getPerWorldStorage();
                data = (WorldData)storage.func_75742_a(WorldData.class, DATA_ID);
                if (data == null) {
                    data = new WorldData(DATA_ID);
                    storage.func_75745_a(DATA_ID, (WorldSavedData)data);
                }
            } else {
                data = new WorldData(DATA_ID);
            }
            DATA_MAP.put(world, data);
        }
        return data;
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(World world, BlockPos pos) {
        ChunkPos chunkPos = new ChunkPos(pos);
        ChunkLoc location = new ChunkLoc(world, chunkPos);
        return WorldData.getChunkPollution(world, location);
    }

    @Nonnull
    public static ChunkPollution getChunkPollution(World world, ChunkLoc location) {
        WorldData data = WorldData.getData(world);
        ChunkPollution pollution = data.pollutionForChunk.get(location);
        if (pollution == null) {
            pollution = new ChunkPollution(location);
            data.pollutionForChunk.put(location, pollution);
        }
        return pollution;
    }

    @Nonnull
    public static EntityPollution getEntityPollution(Entity entity) {
        World world = entity.func_130014_f_();
        WorldData data = WorldData.getData(world);
        EntityPollution pollution = data.pollutionForEntity.get(entity);
        if (pollution == null) {
            pollution = new EntityPollution(entity);
            data.pollutionForEntity.put(entity, pollution);
        }
        if (pollution.isOutdated()) {
            pollution.update();
        }
        return pollution;
    }

    public EntityPollutant.SpawnLimiter getPollutantEntityLimiter() {
        return this.pollutantEntityLimiter;
    }

    public static void initBiomeConfigs() {
        UnitConfig config;
        for (Biome biome : ForgeRegistries.BIOMES.getValues()) {
            config = Biomes.createConfigFor((ForgeMod)Main.instance, (Biome)biome);
            config.save();
        }
        for (Path path : UnitConfig.listCustomConfigs((Path)Biomes.getConfigsBaseDir((ForgeMod)Main.instance), null)) {
            config = new UnitConfig(path.toFile());
            int biomeId = Biomes.getId((ForgeConfig)config);
            boolean enabled = Biomes.isConfigEnabled((ForgeConfig)config);
            Biome biome = Biome.func_150568_d((int)biomeId);
            if (biome != null) {
                for (Pollutant pollutant : Main.getPollutants().getAll()) {
                    for (MultiConfigProperty.BaseProperty<Biome, ?> property : pollutant.getBiomeProperties()) {
                        property.putValueFrom((ForgeConfig)config, (Object)biome, enabled);
                    }
                }
                config.save();
                continue;
            }
            Biomes.logMissingId((ForgeMod)Main.instance, (ForgeConfig)config);
        }
    }

    public static void removeDataFor(World world) {
        DATA_MAP.remove(world);
    }

    public static void scheduleEmissionFor(TileEntity tile, Set<BlockState> relatedBlocks, Pollutant<?> pollutant, int amount) {
        World world = tile.func_145831_w();
        if (ForgeWorld.isServerSide((World)world)) {
            WorldData data = WorldData.getData(world);
            TileEmission emission = data.emissionForTile.get(tile);
            if (emission != null && emission.exists()) {
                emission.add(relatedBlocks).add(pollutant, amount);
            } else {
                emission = TileEmission.from(tile, relatedBlocks, pollutant, amount);
                data.emissionForTile.put(tile, emission);
            }
        }
    }

    public static void scheduleEmissionFor(Entity entity, Emitter emitter) {
        World world = entity.func_130014_f_();
        if (ForgeWorld.isServerSide((World)world)) {
            WorldData data = WorldData.getData(world);
            EntityEmission emission = EntityEmission.from(entity, emitter);
            data.emissionForEntity.put(entity, emission);
        }
    }

    public static void removeScheduledEmissionFor(Entity entity) {
        World world = entity.func_130014_f_();
        if (ForgeWorld.isServerSide((World)world)) {
            WorldData data = WorldData.getData(entity.func_130014_f_());
            data.emissionForEntity.remove(entity);
        }
    }

    public static void updateScheduledEmissions(World world) {
        if (ForgeWorld.isServerSide((World)world)) {
            IScheduledEmission emission;
            WorldData data = WorldData.getData(world);
            Iterator<IScheduledEmission> iterator = data.emissionForTile.values().iterator();
            while (iterator.hasNext()) {
                emission = iterator.next();
                if (((TileEmission)emission).exists()) {
                    ((TileEmission)emission).update();
                    continue;
                }
                iterator.remove();
            }
            iterator = data.emissionForEntity.values().iterator();
            while (iterator.hasNext()) {
                emission = (EntityEmission)iterator.next();
                if (((EntityEmission)emission).exists()) {
                    ((EntityEmission)emission).update();
                    continue;
                }
                iterator.remove();
            }
        }
    }

    public void removePollutionInfoAt(ChunkLoc location) {
        this.pollutionForChunk.remove(location);
    }

    public void removePollutionInfoFor(Entity entity) {
        this.pollutionForEntity.remove(entity);
    }

    public void func_76184_a(NBTTagCompound compound) {
        NBTTagList list = compound.func_150295_c(DATA_ID, ForgeNBT.Types.COMPOUND.id);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            BlockPos pos = BlockPos.func_177969_a((long)tag.func_74763_f("LOCATION"));
            ChunkLoc location = new ChunkLoc(pos.func_177956_o(), new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
            ChunkPollution pollution = new ChunkPollution(location);
            pollution.readFrom(tag);
            this.pollutionForChunk.put(pollution.getLocation(), pollution);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        return compound;
    }

    public static class GetSkyColor
    extends GetSkyColorHook {
        public static Vec3d handle(Vec3d vanillaColor, Entity entity) {
            if (PlayerEvents.Smog.colorSky && PlayerEvents.Smog.enoughDensity() && PlayerEvents.Smog.color != null) {
                ColorARGB color = PlayerEvents.Smog.color;
                Vec3d vec = new Vec3d((double)color.getRed().toFloat(), (double)color.getGreen().toFloat(), (double)color.getBlue().toFloat());
                return vec;
            }
            return vanillaColor;
        }
    }

    public static class LavaTouchesWater
    extends LavaTouchesWaterHook {
        public static void handle(World world, BlockPos pos, IBlockState oldState) {
            Main.getSources().lavaMixingWater.emitAt(world, pos);
        }
    }

    public static class BlockExploded
    extends BlockExplodedHook {
        public static void handle(World world, BlockPos pos, Explosion explosion, IBlockState oldState) {
            if (ForgeWorld.isClientSide((World)world)) {
                return;
            }
            IBlockState newState = world.func_180495_p(pos);
            com.endertech.minecraft.mods.adpother.sources.Explosion source = Main.getSources().explosion;
            if (source.getRelatedId().getBlockState().matches(newState)) {
                boolean itemDropped;
                source.emitAt(world, pos);
                WorldData.onBlockBroken(world, pos, oldState);
                float size = 1.0f;
                boolean bl = itemDropped = size < 1.0f ? true : CommonMath.Random.result((float)(1.0f / size));
                if (!itemDropped) {
                    BlockCaughtFire.onBlockBurnt(world, pos, oldState);
                }
            }
        }
    }

    public static class BlockUpdateTick
    extends BlockRandomTickHook {
        protected MethodSignature getHandler() {
            return Handlers.ON_BLOCK_RANDOM_TICK;
        }
    }

    public static class BlockStateChange
    extends BlockStateChangeHook {
        public static void handle(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
            block5: {
                BlockPos movePos;
                if (!ForgeWorld.isServerSide((World)world)) {
                    return;
                }
                boolean oldStateIsPollutant = oldState.func_177230_c() instanceof Pollutant;
                boolean newStateIsPollutant = newState.func_177230_c() instanceof Pollutant;
                if (!oldStateIsPollutant && !newStateIsPollutant) {
                    return;
                }
                ChunkPollution pollution = WorldData.getChunkPollution(world, pos);
                if (oldStateIsPollutant) {
                    pollution.increaseBy(world, pos, oldState, -1);
                }
                if (newStateIsPollutant) {
                    pollution.increaseBy(world, pos, newState, 1);
                }
                if (!oldStateIsPollutant || newStateIsPollutant || ForgeWorld.isAirBlock((IBlockState)newState) || newState.func_177230_c() instanceof BlockDynamicLiquid) break block5;
                Pollutant pollutant = (Pollutant)oldState.func_177230_c();
                int amount = pollutant.getCarriedPollutionAmount(oldState);
                List movePositions = ForgeWorld.Position.getAroundCube((BlockPos)pos);
                Collections.shuffle(movePositions);
                int count = 0;
                Iterator iterator = movePositions.iterator();
                while (iterator.hasNext() && (count += pollutant.pump(world, movePos = (BlockPos)iterator.next(), amount - count)) < amount) {
                }
            }
        }
    }

    public static class BlockCaughtFire
    extends BlockCaughtFireHook {
        public static boolean generateEmissions = true;

        public static void handle(World world, BlockPos pos) {
            IBlockState state = world.func_180495_p(pos);
            BlockCaughtFire.onBlockBurnt(world, pos, state);
        }

        public static void onBlockBurnt(World world, BlockPos pos, IBlockState state) {
            Fuel fuel;
            if (generateEmissions && ForgeWorld.isServerSide((World)world) && (fuel = (Fuel)Main.getFuels().findBy(state)) != null) {
                fuel.emitAt(world, pos);
            }
        }
    }

    public static class FurnaceFuelBurned
    extends FurnaceFuelBurnedHook {
        public static boolean generateEmissions = true;

        public static void handle(TileEntity tile, ItemStack stack) {
            if (generateEmissions) {
                WorldData.onFuelBurned(tile, stack);
            }
        }
    }
}

