/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Generator {
    public static int spiral(World world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int count = 0;
        int halfChunk = 7;
        int startX = bounds.getX().getMin() + 7;
        int startZ = bounds.getZ().getMin() + 7;
        Biome biome = world.func_180494_b(new BlockPos(startX, 0, startZ));
        int startY = pollutant.getConcentrationAltitudeIn(biome);
        BlockPos startPos = new BlockPos(startX, startY, startZ);
        int maxLength = 15;
        int offsetY = 0;
        block0: while (true) {
            BlockPos[] blockPosArray = new BlockPos[]{startPos.func_177981_b(offsetY), startPos.func_177979_c(offsetY)};
            int n = blockPosArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                BlockPos pos = blockPosArray[n2];
                if (count >= amount || !pollutant.getAltitudeBounds().encloses(Integer.valueOf(pos.func_177956_o()))) {
                    return count;
                }
                boolean pumped = false;
                if (pollutant.pump(world, pos)) {
                    pumped = true;
                    ++count;
                }
                int length = 1;
                int turnsCount = 0;
                block2: while (true) {
                    EnumFacing[] enumFacingArray = ForgeWorld.Direction.CLOCKWISE_HORIZONTALS;
                    int n3 = enumFacingArray.length;
                    int n4 = 0;
                    while (true) {
                        if (n4 >= n3) continue block2;
                        EnumFacing facing = enumFacingArray[n4];
                        if (length > 15) break block2;
                        for (int n5 = 1; n5 <= length; ++n5) {
                            if (count >= amount) {
                                return count;
                            }
                            if (!pollutant.pump(world, pos = pos.func_177972_a(facing))) continue;
                            pumped = true;
                            ++count;
                        }
                        if (length < 15 && ++turnsCount > 1 || turnsCount > 2) {
                            ++length;
                            turnsCount = 0;
                        }
                        ++n4;
                    }
                    break;
                }
                if (!pumped) {
                    ++offsetY;
                }
                ++n2;
            }
            break;
        }
    }

    public static int generate(World world, WorldBounds bounds, Pollutant<?> pollutant, int amount) {
        return Generator.spots(world, bounds, pollutant, amount);
    }

    public static int spots(World world, WorldBounds bounds, Pollutant<?> pollutant, int amount) {
        int count;
        int lastgen;
        for (count = 0; count < amount; count += lastgen) {
            BlockPos startPos = new BlockPos(bounds.getX().randomBetween().intValue(), 0, bounds.getZ().randomBetween().intValue());
            startPos = startPos.func_177982_a(0, pollutant.getConcentrationAltitudeIn(world.func_180494_b(startPos)), 0);
            int remains = amount - count;
            int generate = (int)CommonMath.Random.between((float)1.0f, (float)MathHelper.func_76129_c((float)amount));
            if (generate > remains) {
                generate = remains;
            }
            lastgen = pollutant.generateAt(world, startPos, generate, 16);
            if (lastgen != 0) continue;
            break;
        }
        return count;
    }

    protected static boolean inPyramidBounds(ChunkBounds bounds, BlockPos pos, int startY) {
        int dx = Math.min(Math.abs(bounds.getX().getMin() - pos.func_177958_n()), Math.abs(bounds.getX().getMax() - pos.func_177958_n()));
        int dz = Math.min(Math.abs(bounds.getZ().getMin() - pos.func_177952_p()), Math.abs(bounds.getZ().getMax() - pos.func_177952_p()));
        int dy = Math.abs(pos.func_177956_o() - startY);
        return bounds.encloses(pos) && dy <= dx && dy <= dz;
    }

    public static int random(World world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int count = 0;
        block0: while (count < amount) {
            int x = bounds.getX().randomBetween();
            int z = bounds.getY().randomBetween();
            Biome biome = world.func_180494_b(new BlockPos(x, 0, z));
            int startY = pollutant.getConcentrationAltitudeIn(biome);
            for (int offsetY = 0; offsetY <= startY; ++offsetY) {
                for (int k : new int[]{-1, 1}) {
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, startY + k * offsetY, z);
                    if (!bounds.encloses((BlockPos)pos)) continue;
                    int pumped = pollutant.pump(world, (BlockPos)pos, amount - count);
                    count += pumped;
                    if (pumped > 0) continue block0;
                }
            }
        }
        return count;
    }

    public static int randomAfterSpiral(World world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int pumpsCount = 0;
        int randomMax = 64;
        if (amount > 64) {
            pumpsCount = Generator.spiral(world, bounds, pollutant, amount - 64);
        }
        int remain = amount - pumpsCount;
        return pumpsCount += Generator.random(world, bounds, pollutant, remain);
    }

    public static int randomAndSpots(World world, ChunkBounds bounds, Pollutant<?> pollutant, int amount) {
        int randomMax = 256;
        int pumpsCount = Generator.random(world, bounds, pollutant, Math.min(amount, 256));
        int remain = amount - pumpsCount;
        return pumpsCount += Generator.spots(world, (WorldBounds)bounds, pollutant, remain);
    }
}

