/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitsInitWithEnum;
import com.endertech.minecraft.mods.adpother.blocks.Carbon;
import com.endertech.minecraft.mods.adpother.blocks.Dust;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.blocks.Sulfur;
import com.endertech.minecraft.mods.adpother.blocks.UserGasEmission;
import javax.annotation.Nullable;
import net.minecraft.block.material.MapColor;
import net.minecraft.util.text.TextFormatting;

public class Pollutants
extends UnitsInitWithEnum<Pollutant<?>, BuiltIn> {
    public Pollutants(ForgeMod mod) {
        super(mod, BuiltIn.class);
    }

    public Pollutant<?> createDefaultUnitFrom(UnitConfig config, BuiltIn e) {
        e.instance = e.factory.create(this.getMod(), config, e.func_176610_l());
        return e.instance;
    }

    public Pollutant<?> createCustomUnitFrom(UnitConfig config, String name) {
        return new UserGasEmission(this.getMod(), config, name, 512, 127, 0.15f, 50, MapColor.field_151678_z, TextFormatting.DARK_PURPLE);
    }

    @Nullable
    public Pollutant<?> findBy(String name) {
        for (Pollutant pollutant : this.getAll()) {
            if (!pollutant.getId().getRegName().equalsIgnoreCase(name)) continue;
            return pollutant;
        }
        return null;
    }

    public static enum BuiltIn implements IForgeEnum
    {
        CARBON(Carbon::new),
        SULFUR(Sulfur::new),
        DUST(Dust::new);

        private final IFactory<?> factory;
        private Pollutant<?> instance;

        private BuiltIn(IFactory<?> factory) {
            this.factory = factory;
        }

        public Pollutant<?> get() {
            return this.instance;
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }
    }

    static interface IFactory<T extends Pollutant<?>> {
        public T create(ForgeMod var1, UnitConfig var2, String var3);
    }
}

