/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.common.KeyValuePair;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.EmittersInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.compat.GregtechCE;
import com.endertech.minecraft.mods.adpother.compat.HeatAndClimate;
import com.endertech.minecraft.mods.adpother.compat.ImmersiveVehicles;
import com.endertech.minecraft.mods.adpother.compat.TConstruct;
import com.endertech.minecraft.mods.adpother.emissions.Emissions;
import com.endertech.minecraft.mods.adpother.sources.CharcoalPit;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collections;
import java.util.Map;

public class Emitters
extends EmittersInit<Emitter, BuiltInEmitters> {
    public Emitters(ForgeMod mod) {
        super(mod, BuiltInEmitters.class);
    }

    public Emitter createCustomUnitFrom(UnitConfig config, String name) {
        return new Emitter(config, UnitId.EMPTY, KeyValuePair.EMPTY, false, "", false, new String[0], Emissions.of());
    }

    public Emitter createDefaultUnitFrom(UnitConfig config, BuiltInEmitters e) {
        UnitId id = e.id.isEmpty() ? UnitId.from((Enum)e, (boolean)true) : UnitId.from((String)e.id);
        return e.createEmitter(config, id);
    }

    public Map<BlockState, Emitter> getBlockStates() {
        return Collections.unmodifiableMap(this.blockStates);
    }

    static enum BuiltInEmitters implements IForgeEnum
    {
        actuallyadditions$block_grinder$1(0.0f, 0.0f, 0.8f, ""),
        actuallyadditions$block_grinder_double$1(0.0f, 0.0f, 1.2f, ""),
        atum$limestone_furnace_lit(0.8f, 0.08f),
        atum$kiln("atum:kiln:[is_burning=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"atum:kiln_fake:*"}),
        betterboilers$controller$1(0.8f, 0.08f),
        buildcraft$engine_stirling("buildcraftcore:engine:1", 0.8f, 0.08f, 0.0f, "burnTime", "isRedstonePowered=1b"),
        buildcraft$engine_combustion("buildcraftcore:engine:2", 0.4f, 0.04f, 0.0f, "burnTime", "isRedstonePowered=1b"),
        cfm$grill(0.8f, 0.08f, "fire"),
        cfm$oven(0.8f, 0.08f, "cookingTime"),
        cfm$fire_pit_on(0.8f, 0.08f),
        charcoal_pit$custom_furnace("charcoal_pit:custom_furnace:[active=true]", 0.8f, 0.08f, 0.0f, ""),
        charcoal_pit$bloomery("charcoal_pit:bloomery_hatch:[active=true]", 0.8f, 0.08f, 0.0f, ""),
        cookingforblockheads$toaster(0.4f, 0.0f, "Active"),
        deepresonance$smelter("deepresonance:smelter:[working=true]", 0.8f, 0.08f, 0.0f, ""),
        dumpsterdiving$reingotor("dumpsterdiving:trash_furn:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        dumpsterdiving$reprocessor("dumpsterdiving:trash_furn_n:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        dumpsterdiving$regrinder("dumpsterdiving:trash_furn_g:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        embers$ember_bore("", 0.0f, 0.0f, 1.2f, "isRunning", "", new String[]{"embers:mech_edge:*", "embers:mech_core"}),
        embers$melter("embers:block_furnace", 0.8f, 0.16f, 0.0f, "progress", "", new String[]{"embers:block_furnace:*"}),
        f0_resources$burner_drill("f0-resources:burner_drill_part:*", 0.0f, 0.0f, 0.8f, "rotating"),
        f0_resources$drill("f0-resources:drill_part:*", 0.0f, 0.0f, 0.8f, "rotating"),
        funores$metalfurnace(0.8f, 0.08f, "BurnTime"),
        funores$alloysmelter(0.8f, 0.8f, "BurnTime"),
        forestry$wood_pile("forestry:wood_pile:[active=true]", 0.8f, 0.08f, 0.0f, ""){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new CharcoalPit(config, id, this.emissions);
            }
        }
        ,
        gadgetrycore$alloy_furnace(0.8f, 0.8f, "ticks"),
        gadgetrymachines$furnace_gen(0.8f, 0.08f, "ticks"),
        gadgetrymachines$grinder(0.0f, 0.0f, 0.8f, "progress"),
        galacticraft$coal_generator("galacticraftcore:machine:[type=coal_generator]", 0.8f, 0.08f, 0.0f, "itemCookTime"),
        galacticraft$ingot_comressor("galacticraftcore:machine:[type=ingot_compressor]", 0.8f, 0.16f, 0.0f, "smeltingTicks"),
        giacomosfoundry$foundry_lit(0.8f, 0.4f),
        gregtech_ce$machines("gregtech:machine:*", 0.8f, 0.08f, 0.0f, "", "", new String[0]){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new GregtechCE.Machine(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        heatandclimate$gas_burner("dcs_climate:dcs_device_gas_burner:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        heatandclimate$fuel_stove("dcs_climate:dcs_device_fuelstove:*", 0.8f, 0.08f, 0.0f, "BurnTime"),
        heatandclimate$diesel_engine("dcs_climate:dcs_device_diesel_engine:*", 1.2f, 0.12f, 0.0f, "BurnTime"),
        heatandclimate$motor_cart("dcs_climate:dcs.machine.motor_cart", 8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new HeatAndClimate.MotorEntity(config, id, this.emissions);
            }
        }
        ,
        heatandclimate$motor_scooter("dcs_climate:dcs.machine.motor_scooter", 8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new HeatAndClimate.MotorEntity(config, id, this.emissions);
            }
        }
        ,
        ic2classic$iron_furnace("ic2:blockmachinelv:1", 0.8f, 0.08f, 0.0f, "fuel"),
        ic2classic$stone_macerator("ic2:blockmachinelv:15", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$wood_gasificator("ic2:blockmachinelv2:0", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$generator("ic2:blockgenerator:0", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$liquid_fuel("ic2:blockgenerator:10", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$slag("ic2:blockgenerator:11", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2classic$fuel_boiler("ic2:blockgenerator:14", 0.8f, 0.08f, 0.0f, "Fuel"),
        ic2$_common_0("ic2:te:0"),
        ic2$_common_1("ic2:te:1"),
        ic2$generator("ic2:te:3", 0.8f, 0.08f, 0.0f, "active"),
        ic2$geothermal_generator("ic2:te:4", 0.8f, 0.8f, 0.0f, "active"),
        ic2$semifluid_generator("ic2:te:7", 0.8f, 0.08f, 0.0f, "active"),
        ic2$solid_heat_generator("ic2:te:15", 0.8f, 0.08f, 0.0f, "active"),
        ic2$iron_furnace("ic2:te:46", 0.8f, 0.08f, 0.0f, "active"),
        ic2$macerator("ic2:te:47", 0.0f, 0.0f, 0.8f, "active"),
        ic2$centrifuge("ic2:te:52", 0.0f, 0.0f, 0.8f, "active"),
        immersiveengineering$alloy_kiln("immersiveengineering:stone_device:7", 0.27f, 0.27f, 0.0f, "active"),
        immersiveengineering$coke_oven("immersiveengineering:stone_device:0", 0.08f, 0.008f, 0.0f, "active"),
        immersiveengineering$crusher("immersiveengineering:metal_multiblock:1", 0.0f, 0.0f, 0.1f, "active"),
        immersiveengineering$excavator_wheel("immersiveengineering:metal_multiblock:12", 0.0f, 0.0f, 0.1f, "active"),
        immersiveengineering$sample_drill("immersiveengineering:metal_device1:7", 0.0f, 0.0f, 0.8f, "active"),
        immersivetech$boiler("immersivetech:metal_multiblock:4", 0.0f, 0.0f, 0.0f, "#hardcoded", "", new String[]{"immersivetech:metal_multiblock:9"}),
        immersivetech$coke_oven_advanced("immersivetech:stone_multiblock:0", 0.8f, 0.08f, 0.0f, "active", "", new String[]{"immersivetech:stone_multiblock:1"}),
        libvulpes$coal_generator("libvulpes:coalgenerator:[state=true]", 0.8f, 0.08f, 0.0f, ""),
        lucraftcore$furnace_generator("", 0.8f, 0.08f, 0.0f, "Fuel"),
        magneticraft$big_combustion_chamber("", 0.0f, 0.0f, 0.0f, "", "", new String[]{"magneticraft:multiblock_gap:*"}),
        mekanism$crusher("mekanism:machineblock:3", 0.0f, 0.0f, 0.8f, "isActive"),
        mekanism$basic_crushing_factory("mekanism:machineblock:5", 0.0f, 0.0f, 0.8f, "isActive", "recipeType=2"),
        mekanism$advanced_crushing_factory("mekanism:machineblock:6", 0.0f, 0.0f, 1.2f, "isActive", "recipeType=2"),
        mekanism$elite_crushing_factory("mekanism:machineblock:7", 0.0f, 0.0f, 1.8f, "isActive", "recipeType=2"),
        mekanismgenerators$heat_generator("mekanismgenerators:generator:0", 0.8f, 0.08f, 0.0f, "isActive"),
        mekanismgenerators$gas_generator("mekanismgenerators:generator:3", 0.8f, 0.04f, 0.0f, "isActive"),
        mekanismgenerators$bio_generator("mekanismgenerators:generator:4", 0.8f, 0.0f, 0.0f, "isActive"),
        metallurgy$crusher(0.0f, 0.0f, 0.8f, "crush_time"),
        minecraft$furnace_minecart("", 0.8f, 0.08f, 0.0f, "Fuel", "", true),
        mts$mts_entity(8.0f, 0.8f){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new ImmersiveVehicles.Vehicle(config, id, this.emissions);
            }
        }
        ,
        omegacraft$combustion_generator("omegacraft:gen_coalb:*", 0.8f, 0.08f, 0.0f, "fuel"),
        omegacraft$hungry_generator("omegacraft:gen_foodb:*", 0.8f, 0.0f, 0.0f, "fuel"),
        omegacraft$lava_generator("omegacraft:gen_lavab:*", 0.08f, 0.8f, 0.0f, "fuel"),
        omegacraft$crusher("omegacraft:electric_crusherb:*", 0.0f, 0.0f, 0.8f, "running"),
        omegacraft$advanced_crusher("omegacraft:electric_crusher_advb:*", 0.0f, 0.0f, 0.8f, "running"),
        omegacraft$dark_crusher("omegacraft:electric_crusher_darkb:*", 0.0f, 0.0f, 0.8f, "running"),
        pneumaticcraft$air_compressor("pneumaticcraft:air_compressor:[on=true]", 0.8f, 0.08f, 0.0f, ""),
        pneumaticcraft$advanced_air_compressor("pneumaticcraft:advanced_air_compressor:[on=true]", 0.8f, 0.08f, 0.0f, ""),
        primal$hibachi("primal:hibachi:[lit=true]", 0.6f, 0.06f, 0.0f, ""),
        primal$kiln_adobe("primal:kiln_adobe:[lit=true]", 0.8f, 0.08f, 0.0f, ""),
        primal$smelter("primal:smelter:[lit=true]", 0.8f, 0.08f, 0.0f, ""),
        projecte$dm_furnace_lit(0.8f, 0.08f),
        projecte$rm_furnace_lit(0.8f, 0.12f),
        pyrotech$bloomery("pyrotech:bloomery:[type=bottom_lit]", 0.8f, 0.08f, 0.0f, ""),
        pyrotech$wither_forge("pyrotech:wither_forge:[type=bottom_lit]", 0.8f, 0.4f, 0.0f, ""),
        railcraft$boiler_firebox_fluid("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$boiler_firebox_solid("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$cart_furnace("", 0.8f, 0.08f, 0.0f, "Fuel", "", true),
        railcraft$coke_oven("", 0.8f, 0.08f, 0.0f, "cooking", "master=1b"),
        railcraft$coke_oven_red("", 0.8f, 0.08f, 0.0f, "cooking", "master=1b"),
        railcraft$blast_furnace("", 0.8f, 0.08f, 0.0f, "burnTime", "master=1b"),
        railcraft$locomotive_steam_solid("", 0.8f, 0.08f, 0.0f, "burnTime", "", true),
        railcraft$smoker("railcraft:equipment:[variant=smoker]", 0.4f, 0.0f, 0.0f, ""),
        rockhounding_oretiers$bloomery(0.8f, 0.8f, "CastTime"),
        tcomplement$melter("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tcomplement$high_oven_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:scorched_block:*", "tcomplement:high_oven_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tcomplement$porcelain_melter("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tcomplement:melter:*", "tconstruct:seared_tank:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tconstruct$smeltery_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*", "tconstruct:smeltery_io:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        tconstruct$seared_furnace_controller("", 0.8f, 0.8f, 0.0f, "", "", new String[]{"tconstruct:seared:*", "tconstruct:seared_tank:*", "tconstruct:seared_glass:*"}){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new TConstruct.HeatingStructure(config, id, this.relatedBlocks, this.emissions);
            }
        }
        ,
        techguns$grinder("techguns:simplemachine2:*", 0.0f, 0.0f, 0.8f, "progress"),
        techreborn$grinder("techreborn:grinder:[active=true]", 0.0f, 0.0f, 0.8f, ""),
        techreborn$industrial_sawmill("techreborn:industrial_sawmill:[active=true]", 0.05f, 0.0f, 0.8f, ""),
        techreborn$industrial_grinder("techreborn:industrial_grinder:[active=true]", 0.0f, 0.0f, 3.2f, ""),
        tfc$charcoal_forge("tfc:charcoal_forge:[lit=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"tfc:bellows:*", "tfc:crucible:*"}),
        tfc$charcoal_pit("tfc:log_pile:[lit=true]", 0.2f, 0.02f, 0.0f, ""){

            @Override
            Emitter createEmitter(UnitConfig config, UnitId id) {
                return new CharcoalPit(config, id, this.emissions);
            }
        }
        ,
        tfc$firepit("tfc:firepit:[lit=true]", 1.2f, 0.12f, 0.0f, ""),
        tfc$molten("tfc:molten:[lit=true]", 0.8f, 0.08f, 0.0f, "", "", new String[]{"tfc:molten:*"}),
        tfc$pit_kiln("tfc:pit_kiln:[lit=true]", 1.6f, 0.16f, 0.0f, ""),
        thaumcraft$infernal_furnace("", 1.6f, 0.4f, 0.0f, "CookTime", "", new String[]{"thaumcraft:placeholder_obsidian", "thaumcraft:placeholder_brick"}),
        thaumcraft$smelter_basic(0.8f, 0.08f, "BurnTime"),
        thaumcraft$smelter_thaumium(0.9f, 0.09f, "BurnTime"),
        thaumcraft$smelter_void(1.0f, 0.1f, "BurnTime"),
        thermalexpansion$pulverizer("thermalexpansion:machine:1", 0.0f, 0.0f, 0.8f, "Active"),
        thermalexpansion$centrifuge("thermalexpansion:machine:10", 0.0f, 0.0f, 0.4f, "Active"),
        thermalexpansion$dynamo_steam("thermalexpansion:dynamo:0", 0.8f, 0.08f, 0.0f, "Active"),
        thermalexpansion$dynamo_magmatic("thermalexpansion:dynamo:1", 0.2f, 0.32f, 0.0f, "Active"),
        thermalexpansion$dynamo_compression("thermalexpansion:dynamo:2", 0.8f, 0.08f, 0.0f, "Active"),
        thermalexpansion$dynamo_reactant("thermalexpansion:dynamo:3", 0.4f, 0.16f, 0.0f, "Active"),
        thermalexpansion$sawmill("thermalexpansion:machine:2", 0.0f, 0.0f, 0.8f, "Active"),
        toughasnails$campfire("toughasnails:campfire:[burning=true]", 0.4f, 0.08f, 0.0f, "");

        final String id;
        final Emissions emissions;
        final String activeStateTag;
        final String identityTag;
        final boolean isEntity;
        final boolean useDroppedItemMeta;
        final String[] relatedBlocks;

        private BuiltInEmitters(String id) {
            this(id, "", false, "", true, new String[0], Emissions.of());
        }

        private BuiltInEmitters(float carbon, float sulfur) {
            this(carbon, sulfur, "");
        }

        private BuiltInEmitters(float carbon, float sulfur, String activeStateTag) {
            this(carbon, sulfur, 0.0f, activeStateTag);
        }

        private BuiltInEmitters(float carbon, float sulfur, float dust) {
            this(carbon, sulfur, dust, "");
        }

        private BuiltInEmitters(float carbon, float sulfur, float dust, String activeStateTag) {
            this("", carbon, sulfur, dust, activeStateTag, "", false);
        }

        private BuiltInEmitters(String id, float carbon, float sulfur) {
            this(id, carbon, sulfur, 0.0f, "");
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag) {
            this(id, carbon, sulfur, dust, activeStateTag, "");
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag) {
            this(id, carbon, sulfur, dust, activeStateTag, identityTag, false);
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag, String[] relatedBlocks) {
            this(id, activeStateTag, false, identityTag, false, relatedBlocks, Emissions.of().carbon(carbon).sulfur(sulfur).dust(dust));
        }

        private BuiltInEmitters(String id, float carbon, float sulfur, float dust, String activeStateTag, String identityTag, boolean isEntity) {
            this(id, activeStateTag, isEntity, identityTag, false, new String[0], Emissions.of().carbon(carbon).sulfur(sulfur).dust(dust));
        }

        private BuiltInEmitters(String id, String activeStateTag, boolean isEntity, String identityTag, boolean useDroppedItemMeta, String[] relatedBlocks, Emissions emissions) {
            this.id = id;
            this.emissions = emissions;
            this.activeStateTag = activeStateTag;
            this.identityTag = identityTag;
            this.isEntity = isEntity;
            this.useDroppedItemMeta = useDroppedItemMeta;
            this.relatedBlocks = relatedBlocks;
        }

        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        Emitter createEmitter(UnitConfig config, UnitId id) {
            return new Emitter(config, id, KeyValuePair.from((String)this.identityTag), this.isEntity, this.activeStateTag, this.useDroppedItemMeta, this.relatedBlocks, this.emissions);
        }
    }
}

