/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.EntityPollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class EntityEvents {
    static final GameTime UPDATE_INTERVAL = GameTime.second();

    @SubscribeEvent
    public static void canEntityUpdate(EntityEvent.CanUpdate event) {
        if (event.getEntity() instanceof EntityPollutant && !event.getCanUpdate()) {
            event.setCanUpdate(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase living = event.getEntityLiving();
        World world = living.func_130014_f_();
        if (!ForgeWorld.isServerSide((World)world)) {
            return;
        }
        if (!UPDATE_INTERVAL.pastIn(world)) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution((Entity)living);
        int combinedDamage = pollution.getInfos().map(info -> info.getPollutant()).mapToInt(pollutant -> {
            boolean directContact = pollution.isDirectContactWith((Pollutant<?>)((Object)pollutant));
            if (!pollutant.canAffectEntity((Entity)living, directContact)) {
                return 0;
            }
            int damage = pollution.getDamageFrom((Pollutant<?>)((Object)pollutant));
            Map<ItemStack, IStorageItem> protectItems = pollutant.getProtectiveItems(living);
            if (protectItems.isEmpty()) {
                if (!EntityEvents.killWeakLiving(living, damage)) {
                    if (directContact) {
                        int amplifier = pollutant.getCarriedPollutionAmount(pollution.getState()) - 1;
                        pollutant.getNegativeEffects().updateDirectOn(living, amplifier);
                    }
                    Percentage influence = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant));
                    pollutant.getNegativeEffects().updateGlobalOn(living, influence);
                }
            } else {
                protectItems.entrySet().forEach(entry -> {
                    ItemStack stack = (ItemStack)entry.getKey();
                    IStorageItem item = (IStorageItem)entry.getValue();
                    item.fill(stack, (Pollutant<?>)((Object)pollutant), damage);
                });
            }
            return damage;
        }).sum();
        Main.getRespirators().updateEffectFor(living, combinedDamage);
    }

    static boolean killWeakLiving(EntityLivingBase living, int damage) {
        if (EntityEvents.isHostileMob(living)) {
            return false;
        }
        float health = living.func_110143_aJ();
        if (ForgeEntity.isServerSide((Entity)living) && health <= (float)damage && !(living instanceof EntityPlayer)) {
            living.func_70097_a(DamageSource.field_82727_n, (float)damage);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onCreatureJoinWorld(EntityJoinWorldEvent event) {
        EntityCreature creature = EntityEvents.getServerEntityOf(EntityCreature.class, (EntityEvent)event);
        if (EntityEvents.isHostileMob((EntityLivingBase)creature)) {
            return;
        }
        if (creature instanceof IAnimals) {
            EntityPollution pollution = WorldData.getEntityPollution((Entity)creature);
            pollution.getDominantPollutant(pollutant -> pollutant.canAffectEntity((Entity)creature, true)).ifPresent(pollutant -> {
                float factor = pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toFraction();
                double baseHealth = creature.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b();
                int newHealth = IntBounds.from((Integer)1, (Integer)((int)baseHealth)).approxDown(factor);
                creature.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)newHealth);
            });
        }
    }

    @Nullable
    static <T extends Entity> T getServerEntityOf(Class<T> clazz, EntityEvent event) {
        Entity entity = event.getEntity();
        if (clazz.isInstance(entity) && EntityEvents.isServerSide(event)) {
            return (T)entity;
        }
        return null;
    }

    public static boolean isHostileMob(EntityLivingBase living) {
        return living instanceof IMob;
    }

    static boolean isServerSide(EntityEvent event) {
        return !event.isCanceled() && ForgeEntity.isServerSide((Entity)event.getEntity());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingHeal(LivingHealEvent event) {
        float health;
        EntityAnimal animal = EntityEvents.getServerEntityOf(EntityAnimal.class, (EntityEvent)event);
        if (animal != null && (health = animal.func_110143_aJ()) < animal.func_110138_aP() && health + event.getAmount() >= animal.func_110138_aP()) {
            Main.getSources().animalFeeding.emitFrom(animal, 1.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onLivingDeath(LivingDeathEvent event) {
        EntityAnimal animal = EntityEvents.getServerEntityOf(EntityAnimal.class, (EntityEvent)event);
        if (animal != null) {
            Main.getSources().animalDeath.emitFrom(animal, 1.0f);
        }
    }
}

