/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.common.Args;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IHaveConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import com.endertech.minecraft.mods.adpother.config.IReloadableData;
import com.endertech.minecraft.mods.adpother.events.EntityEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class NegativeEffects
implements IReloadableData {
    protected int duration = (int)GameTime.inServerTicks((CommonTime.Interval)CommonTime.Interval.seconds((double)5.0));
    protected final Direct direct;
    protected final Global global;
    protected final Hostile hostile;

    public NegativeEffects(UnitConfig config, String category) {
        category = IHaveConfig.expandClassCategory(this.getClass(), (String)category);
        this.direct = new Direct(config, category, "direct");
        this.global = new Global(config, category, "global");
        this.hostile = new Hostile(config, category, "hostile");
    }

    public NegativeEffects addDirect(Potion effect) {
        this.direct.addDefaultValues(effect.getRegistryName().toString());
        return this;
    }

    public NegativeEffects addGlobal(Potion effect, Percentage threshold) {
        this.global.addDefaultValues(Args.join((Object[])new Object[]{effect.getRegistryName().toString(), threshold.toString()}));
        return this;
    }

    public NegativeEffects addHostile(Potion effect, Percentage threshold) {
        this.hostile.addDefaultValues(Args.join((Object[])new Object[]{effect.getRegistryName().toString(), threshold.toString()}));
        return this;
    }

    public void updateDirectOn(EntityLivingBase living, int amplifier) {
        if (!ForgeEntity.isServerSide((Entity)living)) {
            return;
        }
        if (this.isHostileMob(living)) {
            return;
        }
        for (Potion potion : this.direct.effects) {
            living.func_70690_d(new PotionEffect(potion, this.duration, amplifier));
        }
    }

    public void updateGlobalOn(EntityLivingBase living, Percentage pollution) {
        if (!ForgeEntity.isServerSide((Entity)living)) {
            return;
        }
        Map<Potion, Percentage> effects = this.isHostileMob(living) ? this.hostile.effects : this.global.effects;
        for (Map.Entry<Potion, Percentage> entry : effects.entrySet()) {
            Potion potion = entry.getKey();
            Percentage threshold = entry.getValue();
            this.addEffectOn(living, potion, this.duration, pollution, threshold);
        }
    }

    public void addEffectOn(EntityLivingBase living, Potion potion, int duration, Percentage pollution, Percentage threshold) {
        if (threshold.getValue() > 0.0f && pollution.getValue() >= threshold.getValue()) {
            int amplifier = 0;
            amplifier = MathHelper.func_76141_d((float)(pollution.getValue() / threshold.getValue())) - 1;
            if (amplifier < 0) {
                amplifier = 0;
            }
            living.func_70690_d(new PotionEffect(potion, duration, amplifier));
        }
    }

    protected boolean isHostileMob(EntityLivingBase living) {
        return EntityEvents.isHostileMob(living);
    }

    @Override
    public void loadData() {
        this.direct.loadData();
        this.global.loadData();
        this.hostile.loadData();
    }

    protected class Hostile
    extends Global {
        public Hostile(UnitConfig config, String category, String key) {
            super(config, category, key);
        }

        @Override
        protected String getComment() {
            return "Effects on hostile mobs.\nFormat: potionID, pollutionThreshold%\n";
        }
    }

    protected class Global
    extends AbstractParsableList {
        protected final Map<Potion, Percentage> effects;

        public Global(UnitConfig config, String category, String key) {
            super((ForgeConfig)config, category, key, new String[0]);
            this.effects = new HashMap<Potion, Percentage>();
        }

        @Override
        protected String getComment() {
            return "Global effects (within the surrounding chunks).\nFormat: potionID, pollutionThreshold%\nPollution threshold is the minimum percentage of pollution to cause this effect.";
        }

        @Override
        protected void parseConfigValues() {
            this.effects.clear();
            for (String string : this.configValues) {
                List<String> split = this.splitArgs(string);
                UnitId id = UnitId.from((String)split.get(0));
                Percentage threshold = Percentage.HUNDRED;
                boolean error = id.isEmpty();
                if (split.size() > 1) {
                    try {
                        threshold = Percentage.parse((String)split.get(1));
                    }
                    catch (Exception e) {
                        error = true;
                    }
                }
                if (!error) {
                    Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(id.toResLoc());
                    if (potion == null) continue;
                    this.effects.put(potion, threshold);
                    continue;
                }
                this.logParsingError(string);
            }
        }
    }

    protected class Direct
    extends AbstractParsableList {
        protected final List<Potion> effects;

        public Direct(UnitConfig config, String category, String key) {
            super((ForgeConfig)config, category, key, new String[0]);
            this.effects = new ArrayList<Potion>();
        }

        @Override
        protected String getComment() {
            return "Direct contact effects.";
        }

        @Override
        protected void parseConfigValues() {
            this.effects.clear();
            for (String string : this.configValues) {
                UnitId id = UnitId.from((String)string);
                Potion potion = (Potion)ForgeRegistries.POTIONS.getValue(id.toResLoc());
                if (potion == null) continue;
                this.effects.add(potion);
            }
        }
    }
}

