/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.config;

import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.StateHashMap;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.config.AbstractParsableList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;

public class CustomReplacements
extends AbstractParsableList {
    protected final Map<BlockState, Replacement> replacements = new StateHashMap();

    public CustomReplacements(UnitConfig config, String category) {
        super((ForgeConfig)config, category, "customReplacements", new String[0]);
    }

    @Override
    protected String getComment() {
        return "List of blocks which this pollutant can replace.\nFormat: pollutionThreshold% -> targetID -> replacementID\nExample: 10% -> minecraft:sand:* -> minecraft:gravel:0";
    }

    @Override
    protected void parseConfigValues() {
        this.replacements.clear();
        for (String string : this.configValues) {
            boolean error;
            List<String> split = this.split(string, "->");
            if (split.size() == 2) {
                split.add(0, "0%");
            }
            boolean bl = error = split.size() < 3;
            if (!error) {
                UnitId source = UnitId.from((String)split.get(1));
                UnitId dest = UnitId.from((String)split.get(2));
                boolean bl2 = error = source.isEmpty() || dest.isEmpty();
                if (!error) {
                    Percentage threshold = null;
                    IBlockState replacement = null;
                    try {
                        threshold = Percentage.parse((String)split.get(0));
                        replacement = dest.getIBlockState();
                    }
                    catch (Exception e) {
                        error = true;
                    }
                    if (!error && replacement != null) {
                        for (BlockState state : source.getAllBlockStates()) {
                            this.replacements.put(state, new Replacement(replacement, threshold));
                        }
                    }
                }
            }
            if (!error) continue;
            this.logParsingError(string);
        }
    }

    @Nullable
    protected Replacement get(IBlockState state) {
        return this.replacements.get(BlockState.from((IBlockState)state));
    }

    public boolean containReplacementFor(IBlockState state) {
        return this.findReplacementFor(state) != null;
    }

    @Nullable
    public IBlockState findReplacementFor(IBlockState state) {
        Replacement replacement = this.get(state);
        return replacement != null ? replacement.blockstate : null;
    }

    public Percentage getThresholdFor(IBlockState state) {
        Replacement replacement = this.get(state);
        return replacement != null ? replacement.threshold : Percentage.ZERO;
    }

    protected class Replacement {
        public final IBlockState blockstate;
        public final Percentage threshold;

        public Replacement(IBlockState blockstate, Percentage threshold) {
            this.blockstate = blockstate;
            this.threshold = threshold;
        }
    }
}

