/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.compat.DynamicTrees;
import com.endertech.minecraft.mods.adpother.config.CustomReplacements;
import java.util.Optional;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.MobEffects;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;

public class Sulfur
extends GasEmission {
    protected final CustomReplacements customReplacements;
    private final MultiConfigProperty.UnitIdProperty<Biome> grassReplacement;
    private final MultiConfigProperty.FloatProperty<Biome> acidRainThreshold;

    public Sulfur(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, name, 512, 127, 0.15f, 40, MapColor.field_151673_t, TextFormatting.YELLOW);
        this.grassReplacement = MultiConfigProperty.UnitIdProperty.from((ForgeConfig)config, (String)this.getUnitCategory(), (String)"grassReplacement", (UnitId)UnitId.from((String)"dirt:2"), (String)"Defines the block which the grass will turn into, when affected by this pollutant.\nExamples: dirt:1 (coarse dirt), dirt:2 (podzol), mycelium:0 (mycelium).");
        this.acidRainThreshold = MultiConfigProperty.FloatProperty.from((ForgeConfig)config, (String)this.getUnitCategory(), (String)"acidRainThreshold", (float)5.0f, (FloatBounds)ForgeBounds.PERCENTAGE.getFloatBounds(), (String)"Defines the minimum percentage of sulfur in a chunk to cause acid rain that affects soil and water.");
        this.addBiomeProperties(new MultiConfigProperty.BaseProperty[]{this.grassReplacement, this.acidRainThreshold});
        this.customReplacements = new CustomReplacements(config, this.getUnitCategory());
        this.customReplacements.addDefaultValues("5% -> minecraft:stone -> minecraft:cobblestone");
        this.filterMaterials.addDefaultValues("wool:*, 8, dustSulfur");
        this.negativeEffects.addDirect(MobEffects.field_76436_u);
        this.negativeEffects.addGlobal(MobEffects.field_76436_u, Percentage.value((float)30.0f)).addGlobal(MobEffects.field_76440_q, Percentage.value((float)50.0f)).addGlobal(MobEffects.field_82731_v, Percentage.value((float)80.0f)).addHostile(MobEffects.field_76429_m, Percentage.value((float)30.0f)).addHostile(MobEffects.field_76424_c, Percentage.value((float)60.0f));
    }

    @Override
    public boolean canAffectEntity(Entity entity, boolean directContact) {
        if (directContact || this.isUnderRainOrStorm(entity.field_70170_p, ForgeEntity.getPositionTop((Entity)entity))) {
            return super.canAffectEntity(entity, directContact);
        }
        return false;
    }

    @Override
    public Pollutant.BlockType getBlockType(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (this.customReplacements.containReplacementFor(state)) {
            return Pollutant.BlockType.CUSTOM;
        }
        return super.getBlockType(world, pos, state);
    }

    public boolean canAffectBlock(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact) {
        IBlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
        switch (type) {
            case IMMUNE: {
                return false;
            }
            case GRASS: 
            case TALLGRASS: {
                if (this.canAffectGrassIn(world.func_180494_b(pos))) break;
                return false;
            }
        }
        switch (type) {
            case TALLGRASS: 
            case FILTER: {
                return true;
            }
            case LEAVES: {
                return this.canAffectLeavesIn(world.func_180494_b(pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(world.func_180494_b(pos));
            }
            case GRASS: 
            case WATER: 
            case CUSTOM: {
                if (directContact) {
                    return true;
                }
                if (!this.shouldRainBeAcidAt(world, pos)) break;
                Percentage percent = this.getPercentageAt(world, pos);
                return percent.getValue() >= this.customReplacements.getThresholdFor(state).getValue();
            }
        }
        return false;
    }

    public boolean shouldRainBeAcidAt(World world, BlockPos pos) {
        Percentage percent = this.getPercentageAt(world, pos);
        float threshold = this.getAcidRainThresholdIn(world.func_180494_b(pos));
        return percent.getValue() >= threshold;
    }

    @Override
    public IBlockState affectBlockAt(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact, IBlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock(world, pos, side, directContact)) {
            IBlockState state = world.func_180495_p(pos);
            Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
            switch (type) {
                case CUSTOM: {
                    IBlockState replacement = this.customReplacements.findReplacementFor(state);
                    if (replacement == null || !world.func_175656_a(pos, replacement) || !this.isAbsorbedIn(world.func_180494_b(pos))) break;
                    return this.getSpreadedState(sourceState);
                }
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case GRASS: {
                    Biome biome = world.func_180494_b(pos);
                    IBlockState replacement = this.getGrassReplacementIn(biome).getIBlockState();
                    if (replacement == null || !world.func_175656_a(pos, replacement) || !this.isAbsorbedIn(biome)) break;
                    return this.getSpreadedState(sourceState);
                }
                case LEAVES: {
                    BlockPos targetPos = DynamicTrees.findBranchUnderLeaves(world, pos).orElse(pos);
                    world.func_175698_g(targetPos);
                    break;
                }
                case TALLGRASS: 
                case PLANT: {
                    world.func_175698_g(pos);
                    break;
                }
                case WATER: {
                    if (!Main.getFluids().pollutedWater.spreadFrom(world, pos)) break;
                    return this.getSpreadedState(sourceState);
                }
            }
        }
        return sourceState;
    }

    public UnitId getGrassReplacementIn(Biome biome) {
        return (UnitId)this.grassReplacement.get((Object)biome);
    }

    public float getAcidRainThresholdIn(Biome biome) {
        return ((Float)this.acidRainThreshold.get((Object)biome)).floatValue();
    }

    @Override
    public void onPostInit(FMLPostInitializationEvent event) {
        this.customReplacements.loadData();
        super.onPostInit(event);
    }
}

