/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.blocks.GasEmission;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.init.Blocks;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fluids.IFluidBlock;

public class Dust
extends GasEmission {
    private MultiConfigProperty.BoolProperty<Biome> canAffectSoil;

    public Dust(ForgeMod mod, UnitConfig config, String name) {
        super(mod, config, name, 512, 0, 0.1f, 80, MapColor.field_151680_x, TextFormatting.WHITE);
        this.canAffectSoil = MultiConfigProperty.BoolProperty.from((ForgeConfig)config, (String)this.getUnitCategory(), (String)"canAffectSoil", (boolean)true, (String)"Defines the ability to influence the soil.");
        this.filterMaterials.addDefaultValues("paper, 8, clay_ball");
        this.addBiomeProperties(new MultiConfigProperty.BaseProperty[]{this.canAffectSoil});
    }

    public boolean canAffectSoilIn(Biome biome) {
        return (Boolean)this.canAffectSoil.get((Object)biome);
    }

    @Override
    public int emitFrom(TileEntity tile, Set<BlockState> relatedBlocks, int amount) {
        if (amount > 0) {
            WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((TileEntity)tile, relatedBlocks);
            Collections.shuffle(neighbors.getFound());
            int count = 0;
            for (BlockPos pos : neighbors.getFound()) {
                if (neighbors.isMultiblockHollow(pos) || (count += this.pump(tile.func_145831_w(), pos, amount - count)) < amount) continue;
                return count;
            }
        }
        return amount;
    }

    @Override
    public boolean affectsPollutionLevel(World world, BlockPos pos, IBlockState state) {
        return false;
    }

    @Override
    public Pollutant.BlockType getBlockType(IBlockAccess world, BlockPos pos, IBlockState state) {
        Block block;
        Pollutant.BlockType type = super.getBlockType(world, pos, state);
        if (type == Pollutant.BlockType.UNKNOWN && ((block = state.func_177230_c()) instanceof BlockLiquid || block instanceof IFluidBlock)) {
            return Pollutant.BlockType.WATER;
        }
        return type;
    }

    public boolean canAffectBlock(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact) {
        IBlockState state = world.func_180495_p(pos);
        Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
        switch (type) {
            case IMMUNE: {
                return false;
            }
            case FILTER: {
                return true;
            }
            case GRASS: 
            case TALLGRASS: {
                return this.canAffectGrassIn(world.func_180494_b(pos));
            }
            case LEAVES: {
                return this.canAffectLeavesIn(world.func_180494_b(pos));
            }
            case PLANT: {
                return this.canAffectPlantsIn(world.func_180494_b(pos));
            }
            case SOIL: {
                return this.canAffectSoilIn(world.func_180494_b(pos)) && this.isUnderRainOrStorm(world, pos);
            }
            case WATER: {
                return true;
            }
        }
        return false;
    }

    @Override
    public IBlockState affectBlockAt(World world, BlockPos pos, Optional<EnumFacing> side, boolean directContact, IBlockState sourceState) {
        if (this.isSamePollutant(sourceState) && this.canAffectBlock(world, pos, side, directContact)) {
            IBlockState state = world.func_180495_p(pos);
            Pollutant.BlockType type = this.getBlockType((IBlockAccess)world, pos, state);
            boolean replaced = false;
            switch (type) {
                case FILTER: {
                    if (!this.isFilteredAt(world, pos, side)) break;
                    return this.getSpreadedState(sourceState);
                }
                case GRASS: {
                    replaced = world.func_175656_a(pos, Blocks.GRASS_PATH);
                    break;
                }
                case TALLGRASS: 
                case LEAVES: 
                case PLANT: 
                case WATER: {
                    replaced = world.func_175698_g(pos);
                    break;
                }
                case SOIL: {
                    if (state == Blocks.COARSE_DIRT) {
                        replaced = world.func_175656_a(pos, Blocks.GRAVEL);
                        break;
                    }
                    replaced = world.func_175656_a(pos, Blocks.COARSE_DIRT);
                    break;
                }
            }
            if (replaced && this.isAbsorbedIn(world.func_180494_b(pos))) {
                return this.getSpreadedState(sourceState);
            }
        }
        return sourceState;
    }
}

