/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother;

import com.endertech.minecraft.forge.blocks.BlockState;
import com.endertech.minecraft.forge.commands.ForgeCommand;
import com.endertech.minecraft.forge.commands.ICommandTask;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.WorldBounds;
import com.endertech.minecraft.mods.adpother.Main;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.ChunkPollution;
import com.endertech.minecraft.mods.adpother.pollution.Generator;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.Entity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class Command
extends ForgeCommand {
    static final String MSG_POLLUTANT_NOT_FOUND = "Pollutant with specified name not found!";

    public Command() {
        super("pother", (ICommandTask[])Tasks.values());
    }

    public void executeTask(World world, String taskName, ICommandSender sender, String[] args) throws CommandException {
        ChunkPollution pollution = WorldData.getChunkPollution(world, sender.func_180425_c());
        Biome biome = world.func_180494_b(sender.func_180425_c());
        if (Tasks.GEN.complyWith(taskName, args)) {
            Pollutant<?> pollutant = Main.getPollutants().findBy(args[0]);
            if (pollutant != null) {
                int amount = Command.func_175764_a((String)args[1], (int)1, (int)pollutant.getCriticalAmountIn(biome));
                int count = Generator.generate(world, (WorldBounds)pollution.getLocation().getBounds(), pollutant, amount);
                this.sendChatMessageTo(sender, "Added " + count + " units of " + this.colored(pollutant));
            } else {
                this.sendChatMessageTo(sender, MSG_POLLUTANT_NOT_FOUND);
            }
            return;
        }
        if (Tasks.CLEAN.complyWith(taskName, args)) {
            pollution.clean(world);
            this.sendChatMessageTo(sender, "Chunk was cleaned from all pollutants");
            return;
        }
        if (Tasks.INFO.complyWith(taskName, args)) {
            for (Pollutant pollutant : Main.getPollutants().getAll()) {
                this.sendChatMessageTo(sender, pollution.getOrCreateInfoFor(pollutant).toChatString(biome));
            }
            int entitiesAmount = WorldData.getData(world).getPollutantEntityLimiter().getTotalAmount();
            this.sendChatMessageTo(sender, "Flying emissions: " + entitiesAmount);
            return;
        }
        if (Tasks.LIST.complyWith(taskName, args)) {
            switch (args[0]) {
                case "emitters": {
                    for (Map.Entry<BlockState, Emitter> entry : Main.getEmitters().getBlockStates().entrySet()) {
                        Main.instance.getLogger().info(entry.getKey() + " -> " + (Object)((Object)entry.getValue()));
                    }
                    return;
                }
            }
        }
        if (Tasks.RECALC.complyWith(taskName, args)) {
            pollution.recalculate(world);
            this.sendChatMessageTo(sender, "Chunk pollution recalculated");
            return;
        }
        if (Tasks.TEST.complyWith(taskName, args)) {
            Entity entity = sender.func_174793_f();
            if (entity == null) {
                this.sendChatMessageTo(sender, "Sender entity is null");
                return;
            }
            RayTraceResult result = ForgeEntity.rayTraceBlockBeingLookedAt((Entity)entity, (float)1.0f, (float)10.0f);
            if (result == null || result.field_72313_a != RayTraceResult.Type.BLOCK) {
                this.sendChatMessageTo(sender, "No block in sight");
                return;
            }
            BlockPos pos = result.func_178782_a();
            switch (args[0]) {
                case "emitter": {
                    UnitId id = UnitId.from((IBlockState)world.func_180495_p(pos));
                    Emitter emitter = (Emitter)Main.getEmitters().findBy(world, pos);
                    String info = id + " at " + pos;
                    if (emitter == null) {
                        this.sendChatMessageTo(sender, "No emitter for " + info);
                        return;
                    }
                    boolean active = emitter.isActive(world, pos);
                    info = (active ? this.colored("active ", TextFormatting.GREEN) : this.colored("inactive ", TextFormatting.GRAY)) + info;
                    float factor = Float.parseFloat(args[1]);
                    emitter.emitAt(world, pos, factor);
                    this.sendChatMessageTo(sender, "Emissions scheduled from " + info);
                    return;
                }
                case "influence": {
                    Pollutant<?> pollutant = Main.getPollutants().findBy(args[1]);
                    if (pollutant != null) {
                        IBlockState state = world.func_180495_p(pos);
                        Pollutant.BlockType type = pollutant.getBlockType((IBlockAccess)world, pos, state);
                        Optional<EnumFacing> side = Optional.of(result.field_178784_b);
                        this.sendChatMessageTo(sender, TextFormatting.DARK_PURPLE + "Target block" + TextFormatting.RESET + "(id: " + UnitId.from((IBlockState)state) + ", type: " + (Object)((Object)type) + ")");
                        this.sendChatMessageTo(sender, this.colored(pollutant) + " influence(direct_contact: " + this.colored(pollutant.canAffectBlock(world, pos, side, true)) + ", global: " + this.colored(pollutant.canAffectBlock(world, pos, side, false)) + ")");
                        this.sendChatMessageTo(sender, this.colored(pollutant) + " canPassThrough(from " + side.get() + " to " + side.get().func_176734_d() + "): " + this.colored(pollutant.canPassThrough(world, pos, side.get(), side.get().func_176734_d())));
                        pollutant.affectBlockAt(world, pos, side, true, pollutant.func_176223_P());
                    } else {
                        this.sendChatMessageTo(sender, MSG_POLLUTANT_NOT_FOUND);
                    }
                    return;
                }
            }
        }
        throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
    }

    String colored(boolean value) {
        return (value ? TextFormatting.GREEN : TextFormatting.RED) + String.valueOf(value) + TextFormatting.RESET;
    }

    String colored(Pollutant<?> pollutant) {
        return pollutant.getTextColor() + pollutant.func_149732_F() + TextFormatting.RESET;
    }

    String colored(String text, TextFormatting color) {
        return color + text + TextFormatting.RESET;
    }

    public int func_82362_a() {
        return 3;
    }

    public static enum Tasks implements ICommandTask
    {
        GEN("carbon | sulfur", "amount"),
        CLEAN(new String[0]),
        INFO(new String[0]),
        LIST("emitters"),
        RECALC(new String[0]),
        TEST("emitter | influence", "factor | pollutant");

        private final String[] usageArgs;

        private Tasks(String ... usageArgs) {
            this.usageArgs = usageArgs;
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String[] getUsageArgs() {
            return this.usageArgs;
        }
    }
}

