/*
 * Decompiled with CFR 0.152.
 */
package com.ocelot.betteranimals.client.render.layer;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class LayerNewEmissive<T extends EntityLivingBase>
implements LayerRenderer<T> {
    private static final Minecraft CLIENT = Minecraft.func_71410_x();
    private final ModelBase model;
    private final ResourceLocation texture;
    private final BrightnessFunction<T> brightnessFunction;
    private final ColorFunction<T> colorFunction;

    public LayerNewEmissive(ModelBase model, ResourceLocation texture, BrightnessFunction<T> brightnessFunction, ColorFunction<T> colorFunction) {
        this.model = model;
        this.texture = texture;
        this.brightnessFunction = brightnessFunction;
        this.colorFunction = colorFunction;
    }

    public LayerNewEmissive(ModelBase model, ResourceLocation texture, BrightnessFunction<T> brightnessFunction) {
        this(model, texture, brightnessFunction, (entity, partialTicks) -> 0xFFFFFF);
    }

    public LayerNewEmissive(ModelBase model, ResourceLocation texture) {
        this(model, texture, (entity, partialTicks) -> 240);
    }

    public void func_177141_a(T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (entity.func_82150_aj()) {
            return;
        }
        GlStateManager.func_179094_E();
        CLIENT.func_110434_K().func_110577_a(this.texture);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179147_l();
        int brightness = this.brightnessFunction.apply(entity, partialTicks);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)brightness, (float)brightness);
        float[] rgbF = LayerNewEmissive.getRGBColorF(this.colorFunction.getColor(entity, partialTicks));
        GlStateManager.func_179131_c((float)rgbF[0], (float)rgbF[1], (float)rgbF[2], (float)1.0f);
        GlStateManager.func_179140_f();
        this.model.func_78087_a(limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale, entity);
        this.model.func_78088_a(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.func_179145_e();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)OpenGlHelper.lastBrightnessX, (float)OpenGlHelper.lastBrightnessY);
        GlStateManager.func_179121_F();
    }

    public boolean func_177142_b() {
        return false;
    }

    public static float[] getRGBColorF(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static interface ColorFunction<T extends EntityLivingBase> {
        public int getColor(T var1, float var2);
    }

    public static interface BrightnessFunction<T extends EntityLivingBase> {
        public int apply(T var1, float var2);
    }
}

